package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Nested;
import java.lang.String;
import io.fabric8.docker.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SearchResultsFluent<A extends SearchResultsFluent<A>> extends Fluent<A>{


    public Integer getNumResults();
    public A withNumResults(Integer numResults);
    public Boolean hasNumResults();
    public String getQuery();
    public A withQuery(String query);
    public Boolean hasQuery();
    public A addToResults(int index,SearchResult item);
    public A setToResults(int index,SearchResult item);
    public A addToResults(SearchResult... items);
    public A addAllToResults(Collection<SearchResult> items);
    public A removeFromResults(SearchResult... items);
    public A removeAllFromResults(Collection<SearchResult> items);
    
/**
 * This method has been deprecated, please use method buildResults instead.
 */
@Deprecated public List<SearchResult> getResults();
    public List<SearchResult> buildResults();
    public SearchResult buildResult(int index);
    public SearchResult buildFirstResult();
    public SearchResult buildLastResult();
    public SearchResult buildMatchingResult(io.fabric8.docker.api.builder.Predicate<SearchResultBuilder> predicate);
    public A withResults(List<SearchResult> results);
    public A withResults(SearchResult... results);
    public Boolean hasResults();
    public SearchResultsFluent.ResultsNested<A> addNewResult();
    public SearchResultsFluent.ResultsNested<A> addNewResultLike(SearchResult item);
    public SearchResultsFluent.ResultsNested<A> setNewResultLike(int index,SearchResult item);
    public SearchResultsFluent.ResultsNested<A> editResult(int index);
    public SearchResultsFluent.ResultsNested<A> editFirstResult();
    public SearchResultsFluent.ResultsNested<A> editLastResult();
    public SearchResultsFluent.ResultsNested<A> editMatchingResult(io.fabric8.docker.api.builder.Predicate<SearchResultBuilder> predicate);

    public interface ResultsNested<N> extends io.fabric8.docker.api.builder.Nested<N>,SearchResultFluent<SearchResultsFluent.ResultsNested<N>>{

        
    public N and();    public N endResult();
}


}
