package io.fabric8.docker.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.docker.api.builder.Fluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface ThrottlingDataFluent<A extends ThrottlingDataFluent<A>> extends Fluent<A>{


    public Long getPeriods();
    public A withPeriods(Long periods);
    public Boolean hasPeriods();
    public Long getThrottledPeriods();
    public A withThrottledPeriods(Long throttledPeriods);
    public Boolean hasThrottledPeriods();
    public Long getThrottledTime();
    public A withThrottledTime(Long throttledTime);
    public Boolean hasThrottledTime();



}
