/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.watcher.standard;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.WatchService;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.watcher.api.BaseWatcher;
import io.fabric8.maven.watcher.api.WatcherContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public class DockerImageWatcher
extends BaseWatcher {
    public DockerImageWatcher(WatcherContext watcherContext) {
        super(watcherContext, "docker-image");
    }

    public boolean isApplicable(List<ImageConfiguration> configs, Set<HasMetadata> resources, PlatformMode mode) {
        return mode == PlatformMode.kubernetes;
    }

    public void watch(List<ImageConfiguration> configs, Set<HasMetadata> resources, PlatformMode mode) {
        BuildService.BuildContext buildContext = this.getContext().getBuildContext();
        WatchService.WatchContext watchContext = this.getContext().getWatchContext();
        watchContext = new WatchService.WatchContext.Builder(watchContext).imageCustomizer(imageConfiguration -> this.buildImage((ImageConfiguration)imageConfiguration)).containerRestarter(imageWatcher -> this.restartContainer((WatchService.ImageWatcher)imageWatcher, resources)).build();
        ServiceHub hub = this.getContext().getServiceHub();
        try {
            hub.getWatchService().watch(watchContext, buildContext, configs);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while watching", ex);
        }
    }

    protected void buildImage(ImageConfiguration imageConfig) throws DockerAccessException, MojoExecutionException {
        String imageName = imageConfig.getName();
        try {
            String imagePrefix = this.getImagePrefix(imageName);
            imageName = imagePrefix + "%t";
            ImageNameFormatter formatter = new ImageNameFormatter(this.getContext().getProject(), new Date());
            imageName = formatter.format(imageName);
            imageConfig.setName(imageName);
            this.log.info("New image name: " + imageConfig.getName(), new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Caught: " + e, new Object[]{e});
        }
    }

    private String getImagePrefix(String imageName) throws MojoExecutionException {
        String imagePrefix = null;
        int idx = imageName.lastIndexOf(58);
        if (idx < 0) {
            throw new MojoExecutionException("No ':' in the image name:  " + imageName);
        }
        imagePrefix = imageName.substring(0, idx + 1);
        return imagePrefix;
    }

    protected void restartContainer(WatchService.ImageWatcher watcher, Set<HasMetadata> resources) throws MojoExecutionException {
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        String imageName = imageConfig.getName();
        try {
            ClusterAccess clusterAccess = new ClusterAccess(this.getContext().getClusterConfiguration());
            KubernetesClient client = clusterAccess.createDefaultClient((Logger)this.log);
            String namespace = clusterAccess.getNamespace();
            String imagePrefix = this.getImagePrefix(imageName);
            for (HasMetadata entity : resources) {
                this.updateImageName(client, namespace, entity, imagePrefix, imageName);
            }
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void updateImageName(KubernetesClient kubernetes, String namespace, HasMetadata entity, String imagePrefix, String imageName) {
        DeploymentConfig resource;
        DeploymentConfigSpec spec;
        String name = KubernetesHelper.getName((HasMetadata)entity);
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null && this.updateImageName(entity, spec2.getTemplate(), imagePrefix, imageName)) {
                ((ScalableResource)((NonNamespaceOperation)kubernetes.extensions().deployments().inNamespace(namespace)).withName(name)).replace((Object)resource2);
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null && this.updateImageName(entity, spec3.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.extensions().replicaSets().inNamespace(namespace)).withName(name)).replace((Object)resource3);
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource4 = (ReplicationController)entity;
            ReplicationControllerSpec spec4 = resource4.getSpec();
            if (spec4 != null && this.updateImageName(entity, spec4.getTemplate(), imagePrefix, imageName)) {
                ((RollableScalableResource)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name)).replace((Object)resource4);
            }
        } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null && this.updateImageName(entity, spec.getTemplate(), imagePrefix, imageName)) {
            OpenShiftClient openshiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)kubernetes);
            if (openshiftClient == null) {
                this.log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
            }
            ((DeployableScalableResource)((NonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name)).replace((Object)resource);
        }
    }

    private boolean updateImageName(HasMetadata entity, PodTemplateSpec template, String imagePrefix, String imageName) {
        List containers;
        boolean answer = false;
        PodSpec spec = template.getSpec();
        if (spec != null && (containers = spec.getContainers()) != null) {
            for (Container container : containers) {
                String image = container.getImage();
                if (image == null || !image.startsWith(imagePrefix)) continue;
                container.setImage(imageName);
                this.log.info("Updating " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity) + " to use image: " + imageName, new Object[0]);
                answer = true;
            }
        }
        return answer;
    }
}

