/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Path;
import com.querydsl.jpa.FactoryExpressionTransformer;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPAQueryBase;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.ScrollableResultsIterator;
import com.querydsl.jpa.hibernate.DefaultSessionHolder;
import com.querydsl.jpa.hibernate.HibernateQuery;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.jpa.hibernate.SessionHolder;
import com.querydsl.jpa.hibernate.StatelessSessionHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHibernateQuery<T, Q extends AbstractHibernateQuery<T, Q>>
extends JPAQueryBase<T, Q> {
    private static final Logger logger = Logger.getLogger(HibernateQuery.class.getName());
    @Nullable
    protected Boolean cacheable;
    @Nullable
    protected Boolean readOnly;
    @Nullable
    protected String cacheRegion;
    @Nullable
    protected String comment;
    protected int fetchSize = 0;
    protected final Map<Path<?>, LockMode> lockModes = new HashMap();
    @Nullable
    protected FlushMode flushMode;
    private final SessionHolder session;
    protected int timeout = 0;

    public AbstractHibernateQuery(Session session) {
        this(new DefaultSessionHolder(session), HQLTemplates.DEFAULT, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateQuery(SessionHolder session, JPQLTemplates patterns, QueryMetadata metadata) {
        super(metadata, patterns);
        this.session = session;
    }

    public long fetchCount() {
        QueryModifiers modifiers = this.getMetadata().getModifiers();
        try {
            Query query = this.createQuery(modifiers, true);
            Long rv = (Long)query.uniqueResult();
            if (rv != null) {
                long l = rv;
                return l;
            }
            throw new QueryException("Query returned null");
        }
        finally {
            this.reset();
        }
    }

    public Query createQuery() {
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    private Query createQuery(@Nullable QueryModifiers modifiers, boolean forCount) {
        JPQLSerializer serializer = this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString);
        Query<?> query = this.session.createQuery(queryString);
        HibernateUtil.setConstants(query, serializer.getConstants(), this.getMetadata().getParams());
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.comment != null) {
            query.setComment(this.comment);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        for (Map.Entry<Path<?>, LockMode> entry : this.lockModes.entrySet()) {
            query.setLockMode(entry.getKey().toString(), entry.getValue());
        }
        if (this.flushMode != null) {
            query.setHibernateFlushMode(this.flushMode);
        }
        if (modifiers != null && modifiers.isRestricting()) {
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                query.setMaxResults(limit.intValue());
            }
            if (offset != null) {
                query.setFirstResult(offset.intValue());
            }
        }
        Expression projection = this.getMetadata().getProjection();
        if (!forCount && projection instanceof FactoryExpression) {
            query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)projection));
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<T> iterate() {
        try {
            Query query = this.createQuery();
            ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
            ScrollableResultsIterator scrollableResultsIterator = new ScrollableResultsIterator(results);
            return scrollableResultsIterator;
        }
        finally {
            this.reset();
        }
    }

    public Stream<T> stream() {
        try {
            Query query = this.createQuery();
            Stream stream = query.getResultStream();
            return stream;
        }
        finally {
            this.reset();
        }
    }

    public List<T> fetch() {
        try {
            List list = this.createQuery().list();
            return list;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults<T> fetchResults() {
        try {
            Query countQuery = this.createQuery(null, true);
            long total = (Long)countQuery.uniqueResult();
            if (total > 0L) {
                QueryModifiers modifiers = this.getMetadata().getModifiers();
                Query query = this.createQuery(modifiers, false);
                List list = query.list();
                QueryResults queryResults = new QueryResults(list, modifiers, total);
                return queryResults;
            }
            QueryResults queryResults = QueryResults.emptyResults();
            return queryResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString) {
        if (logger.isLoggable(Level.FINE)) {
            String normalizedQuery = queryString.replace('\n', ' ');
            logger.fine(normalizedQuery);
        }
    }

    @Override
    protected void reset() {
    }

    public ScrollableResults scroll(ScrollMode mode) {
        try {
            ScrollableResults scrollableResults = this.createQuery().scroll(mode);
            return scrollableResults;
        }
        finally {
            this.reset();
        }
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)this;
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)this;
    }

    public Q setComment(String comment) {
        this.comment = comment;
        return (Q)this;
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)this;
    }

    public Q setLockMode(Path<?> path, LockMode lockMode) {
        this.lockModes.put(path, lockMode);
        return (Q)this;
    }

    public Q setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return (Q)this;
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)this;
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)this;
    }

    public T fetchOne() throws NonUniqueResultException {
        try {
            Object object;
            QueryModifiers modifiers = this.getMetadata().getModifiers();
            Query query = this.createQuery(modifiers, false);
            try {
                object = query.uniqueResult();
            }
            catch (org.hibernate.NonUniqueResultException e) {
                throw new NonUniqueResultException((Exception)((Object)e));
            }
            return (T)object;
        }
        finally {
            this.reset();
        }
    }

    @Override
    protected JPQLSerializer createSerializer() {
        return new JPQLSerializer(this.getTemplates());
    }

    protected void clone(Q query) {
        this.cacheable = ((AbstractHibernateQuery)query).cacheable;
        this.cacheRegion = ((AbstractHibernateQuery)query).cacheRegion;
        this.fetchSize = ((AbstractHibernateQuery)query).fetchSize;
        this.flushMode = ((AbstractHibernateQuery)query).flushMode;
        this.lockModes.putAll(((AbstractHibernateQuery)query).lockModes);
        this.readOnly = ((AbstractHibernateQuery)query).readOnly;
        this.timeout = ((AbstractHibernateQuery)query).timeout;
    }

    protected abstract Q clone(SessionHolder var1);

    public Q clone(Session session) {
        return this.clone(new DefaultSessionHolder(session));
    }

    public Q clone(StatelessSession session) {
        return this.clone(new StatelessSessionHolder(session));
    }

    @Override
    public Q clone() {
        return this.clone(this.session);
    }
}

