/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.ConditionalOnExposedEndpoint;
import io.hawt.springboot.EndpointPathResolver;
import io.hawt.springboot.HawtioEndpoint;
import io.hawt.springboot.HawtioPlugin;
import io.hawt.springboot.HawtioProperties;
import io.hawt.springboot.SpringHawtioContextListener;
import io.hawt.springboot.TrailingSlashFilter;
import io.hawt.system.ConfigManager;
import io.hawt.web.auth.AuthConfigurationServlet;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.AuthenticationFilter;
import io.hawt.web.auth.ClientRouteRedirectFilter;
import io.hawt.web.auth.LoginServlet;
import io.hawt.web.auth.LogoutServlet;
import io.hawt.web.auth.Redirector;
import io.hawt.web.auth.SessionExpiryFilter;
import io.hawt.web.auth.keycloak.KeycloakServlet;
import io.hawt.web.auth.keycloak.KeycloakUserServlet;
import io.hawt.web.filters.BaseTagHrefFilter;
import io.hawt.web.filters.CORSFilter;
import io.hawt.web.filters.CacheHeadersFilter;
import io.hawt.web.filters.ContentSecurityPolicyFilter;
import io.hawt.web.filters.FlightRecordingDownloadFacade;
import io.hawt.web.filters.PublicKeyPinningFilter;
import io.hawt.web.filters.ReferrerPolicyFilter;
import io.hawt.web.filters.StrictTransportSecurityFilter;
import io.hawt.web.filters.XContentTypeOptionsFilter;
import io.hawt.web.filters.XFrameOptionsFilter;
import io.hawt.web.filters.XXSSProtectionFilter;
import io.hawt.web.proxy.ProxyServlet;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jolokia.support.spring.actuator.JolokiaEndpoint;
import org.jolokia.support.spring.actuator.JolokiaEndpointAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.AbstractUrlViewController;

@Configuration
@AutoConfigureAfter(value={JolokiaEndpointAutoConfiguration.class})
@ConditionalOnBean(value={HawtioEndpoint.class})
public class HawtioManagementConfiguration {
    private final String hawtioPath;

    public HawtioManagementConfiguration(EndpointPathResolver pathResolver) {
        this.hawtioPath = pathResolver.resolve("hawtio");
    }

    @Autowired
    public void initializeHawtioPlugins(HawtioEndpoint hawtioEndpoint, Optional<List<HawtioPlugin>> plugins) {
        hawtioEndpoint.setPlugins(plugins.orElse(Collections.emptyList()));
    }

    @Bean
    public ConfigManager hawtioConfigManager(HawtioProperties hawtioProperties) {
        return new ConfigManager(hawtioProperties.get()::get);
    }

    @Bean
    public SimpleUrlHandlerMapping hawtioWelcomeFiles(final EndpointPathResolver pathResolver) {
        AbstractController abstractController = new AbstractController(){

            protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
                return new ModelAndView("forward:" + pathResolver.resolve("hawtio") + "/index.html");
            }
        };
        return new SimpleUrlHandlerMapping(Map.of(pathResolver.resolve("hawtio") + "/", abstractController), 10);
    }

    @Bean
    @ConditionalOnBean(value={JolokiaEndpoint.class})
    @ConditionalOnExposedEndpoint(name="jolokia")
    public SimpleUrlHandlerMapping hawtioUrlMapping(EndpointPathResolver pathResolver) {
        String jolokiaPath = pathResolver.resolve("jolokia");
        String hawtioPath = pathResolver.resolve("hawtio");
        SilentSimpleUrlHandlerMapping mapping = new SilentSimpleUrlHandlerMapping();
        HashMap<String, JolokiaForwardingController> urlMap = new HashMap<String, JolokiaForwardingController>();
        if (!hawtioPath.isEmpty()) {
            String hawtioJolokiaPath = pathResolver.resolveUrlMapping("hawtio", "jolokia", "**");
            urlMap.put(hawtioJolokiaPath, new JolokiaForwardingController(hawtioPath + "/jolokia", jolokiaPath));
            mapping.setOrder(Integer.MIN_VALUE);
        } else {
            urlMap.put("/<DUMMY>", null);
        }
        mapping.setUrlMap(urlMap);
        return mapping;
    }

    @Bean
    public Redirector redirector() {
        Redirector redirector = new Redirector();
        redirector.setApplicationContextPath(this.hawtioPath);
        return redirector;
    }

    @Bean
    @Order(value=0)
    public FilterRegistrationBean<TrailingSlashFilter> trailingSlashFilter(Redirector redirector) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new TrailingSlashFilter(redirector));
        filter.addUrlPatterns(new String[]{this.hawtioPath});
        return filter;
    }

    @Bean
    @Order(value=1)
    public FilterRegistrationBean<SessionExpiryFilter> sessionExpiryFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new SessionExpiryFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=2)
    public FilterRegistrationBean<CacheHeadersFilter> cacheFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CacheHeadersFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=3)
    public FilterRegistrationBean<CORSFilter> hawtioCorsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CORSFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=4)
    public FilterRegistrationBean<XFrameOptionsFilter> xframeOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XFrameOptionsFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=5)
    public FilterRegistrationBean<XXSSProtectionFilter> xxssProtectionFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XXSSProtectionFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=6)
    public FilterRegistrationBean<XContentTypeOptionsFilter> xContentTypeOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XContentTypeOptionsFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=7)
    public FilterRegistrationBean<ContentSecurityPolicyFilter> contentSecurityPolicyFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new ContentSecurityPolicyFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=8)
    public FilterRegistrationBean<StrictTransportSecurityFilter> strictTransportSecurityFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new StrictTransportSecurityFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=9)
    public FilterRegistrationBean<PublicKeyPinningFilter> publicKeyPinningFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new PublicKeyPinningFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=10)
    public FilterRegistrationBean<ReferrerPolicyFilter> referrerPolicyFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new ReferrerPolicyFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=11)
    @ConditionalOnBean(value={JolokiaEndpoint.class})
    @ConditionalOnExposedEndpoint(name="jolokia")
    public FilterRegistrationBean<AuthenticationFilter> jolokiaAuthenticationFilter(EndpointPathResolver pathResolver) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new AuthenticationFilter());
        filter.addUrlPatterns(new String[]{pathResolver.resolveUrlMapping("jolokia", "*")});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        return filter;
    }

    @Bean
    @Order(value=11)
    public FilterRegistrationBean<AuthenticationFilter> hawtioProxyAuthenticationFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new AuthenticationFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/proxy/*"});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        return filter;
    }

    @Bean
    @Order(value=12)
    public FilterRegistrationBean<ClientRouteRedirectFilter> clientRouteRedirectFilter(Redirector redirector, EndpointPathResolver pathResolver) {
        String[] unsecuredPaths = this.prependContextPath(AuthenticationConfiguration.UNSECURED_PATHS);
        FilterRegistrationBean filter = new FilterRegistrationBean();
        ClientRouteRedirectFilter clientRouteRedirectFilter = new ClientRouteRedirectFilter(unsecuredPaths, pathResolver.resolve("hawtio"));
        clientRouteRedirectFilter.setRedirector(redirector);
        filter.setFilter((Filter)clientRouteRedirectFilter);
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @Order(value=13)
    public FilterRegistrationBean<BaseTagHrefFilter> baseTagHrefFilter(EndpointPathResolver pathResolver) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        BaseTagHrefFilter baseTagHrefFilter = new BaseTagHrefFilter();
        filter.setFilter((Filter)baseTagHrefFilter);
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/"});
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/index.html"});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        filter.addInitParameter("applicationContextPath", pathResolver.resolve("hawtio"));
        return filter;
    }

    @Bean
    @Order(value=14)
    public FilterRegistrationBean<FlightRecordingDownloadFacade> flightRecorderDownloadFacade(EndpointPathResolver pathResolver) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new FlightRecordingDownloadFacade());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/jolokia/*"});
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/proxy/*"});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        return filter;
    }

    @Bean
    public ServletRegistrationBean<ProxyServlet> jolokiaProxyServlet() {
        return new ServletRegistrationBean((Servlet)new ProxyServlet(), new String[]{this.hawtioPath + "/proxy/*"});
    }

    @Bean
    public ServletRegistrationBean<KeycloakUserServlet> userServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakUserServlet(), new String[]{this.hawtioPath + "/user/*"});
    }

    @Bean
    public ServletRegistrationBean<LoginServlet> loginServlet(Redirector redirector) {
        LoginServlet loginServlet = new LoginServlet();
        loginServlet.setRedirector(redirector);
        return new ServletRegistrationBean((Servlet)loginServlet, new String[]{this.hawtioPath + "/auth/login"});
    }

    @Bean
    public ServletRegistrationBean<LogoutServlet> logoutServlet(Redirector redirector) {
        LogoutServlet logoutServlet = new LogoutServlet();
        logoutServlet.setRedirector(redirector);
        return new ServletRegistrationBean((Servlet)logoutServlet, new String[]{this.hawtioPath + "/auth/logout"});
    }

    @Bean
    public ServletRegistrationBean<KeycloakServlet> keycloakServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakServlet(), new String[]{this.hawtioPath + "/keycloak/*"});
    }

    @Bean
    public ServletRegistrationBean<AuthConfigurationServlet> oidcServlet() {
        return new ServletRegistrationBean((Servlet)new AuthConfigurationServlet(), new String[]{this.hawtioPath + "/auth/config/*"});
    }

    @Bean
    public ServletListenerRegistrationBean<SpringHawtioContextListener> hawtioContextListener(ConfigManager configManager) {
        return new ServletListenerRegistrationBean((EventListener)((Object)new SpringHawtioContextListener(configManager, this.hawtioPath)));
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> servletContext.getSessionCookieConfig().setHttpOnly(true);
    }

    private String[] prependContextPath(String[] paths) {
        return (String[])Arrays.stream(paths).map(path -> this.hawtioPath + path).toArray(String[]::new);
    }

    private static class SilentSimpleUrlHandlerMapping
    extends SimpleUrlHandlerMapping {
        private static final String DUMMY = "/<DUMMY>";

        private SilentSimpleUrlHandlerMapping() {
        }

        protected void registerHandler(String urlPath, Object handler) {
            if (!DUMMY.equals(urlPath)) {
                super.registerHandler(urlPath, handler);
            }
        }
    }

    private static class JolokiaForwardingController
    extends AbstractUrlViewController {
        private final String hawtioJolokiaPath;
        private final String jolokiaPath;

        JolokiaForwardingController(String hawtioJolokiaPath, String jolokiaPath) {
            this.hawtioJolokiaPath = hawtioJolokiaPath;
            this.jolokiaPath = jolokiaPath;
        }

        protected String getViewNameForRequest(HttpServletRequest request) {
            StringBuilder b = new StringBuilder();
            b.append("forward:");
            b.append(this.jolokiaPath);
            String pathQuery = request.getRequestURI().substring(request.getContextPath().length() + this.hawtioJolokiaPath.length());
            b.append(pathQuery);
            if (request.getQueryString() != null) {
                b.append('?').append(request.getQueryString());
            }
            return b.toString();
        }
    }
}

