/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.vendor.org.apache.http.impl.cookie;

import io.jaegertracing.vendor.org.apache.http.annotation.Immutable;
import io.jaegertracing.vendor.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.jaegertracing.vendor.org.apache.http.cookie.Cookie;
import io.jaegertracing.vendor.org.apache.http.cookie.CookieOrigin;
import io.jaegertracing.vendor.org.apache.http.cookie.MalformedCookieException;
import io.jaegertracing.vendor.org.apache.http.cookie.SetCookie;
import io.jaegertracing.vendor.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import io.jaegertracing.vendor.org.apache.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

