/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.vendor.org.apache.http.message;

import io.jaegertracing.vendor.org.apache.http.HttpRequest;
import io.jaegertracing.vendor.org.apache.http.HttpVersion;
import io.jaegertracing.vendor.org.apache.http.ProtocolVersion;
import io.jaegertracing.vendor.org.apache.http.RequestLine;
import io.jaegertracing.vendor.org.apache.http.annotation.NotThreadSafe;
import io.jaegertracing.vendor.org.apache.http.message.AbstractHttpMessage;
import io.jaegertracing.vendor.org.apache.http.message.BasicRequestLine;
import io.jaegertracing.vendor.org.apache.http.util.Args;

@NotThreadSafe
public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final String method;
    private final String uri;
    private RequestLine requestline;

    public BasicHttpRequest(String method, String uri) {
        this.method = Args.notNull(method, "Method name");
        this.uri = Args.notNull(uri, "Request URI");
        this.requestline = null;
    }

    public BasicHttpRequest(String method, String uri, ProtocolVersion ver) {
        this(new BasicRequestLine(method, uri, ver));
    }

    public BasicHttpRequest(RequestLine requestline) {
        this.requestline = Args.notNull(requestline, "Request line");
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            this.requestline = new BasicRequestLine(this.method, this.uri, HttpVersion.HTTP_1_1);
        }
        return this.requestline;
    }

    public String toString() {
        return this.method + ' ' + this.uri + ' ' + this.headergroup;
    }
}

