/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import java.util.HashMap;
import java.util.Map;

public class MessagingQos {
    public static final int DEFAULT_TTL = 60000;
    public static final Map<String, String> DEFAULTQOS = new HashMap<String, String>();
    private long ttl_ms;
    private Map<String, String> customHeaders = new HashMap<String, String>();

    public MessagingQos() {
        this.ttl_ms = 60000L;
    }

    public MessagingQos(MessagingQos src) {
        this.ttl_ms = src.getRoundTripTtl_ms();
    }

    public MessagingQos(long ttl_ms) {
        this.ttl_ms = ttl_ms;
    }

    public long getRoundTripTtl_ms() {
        return this.ttl_ms;
    }

    public void setTtl_ms(long ttl_ms) {
        this.ttl_ms = ttl_ms;
    }

    public void putCustomMessageHeader(String key, String value) {
        this.checkKeyAndValue(key, value);
        this.customHeaders.put(key, value);
    }

    public void putAllCustomMessageHeaders(Map<String, String> newCustomHeaders) {
        for (Map.Entry<String, String> entry : newCustomHeaders.entrySet()) {
            this.checkKeyAndValue(entry.getKey(), entry.getValue());
        }
        this.customHeaders.putAll(newCustomHeaders);
    }

    private void checkKeyAndValue(String key, String value) {
        String keyPattern = "^[a-zA-Z0-9\\-]*$";
        String valuePattern = "^[a-zA-Z0-9 ;:,+&\\?\\-\\.\\*\\/\\\\]*$";
        if (!key.matches(keyPattern)) {
            throw new IllegalArgumentException("key may only contain alphanumeric characters");
        }
        if (!value.matches(valuePattern)) {
            throw new IllegalArgumentException("value contains illegal character. See JavaDoc for allowed characters");
        }
    }

    public Map<String, String> getCustomMessageHeaders() {
        return this.customHeaders;
    }
}

