/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.serialize;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JoynrListSerializer
extends StdSerializer<List<?>> {
    Map<Class<?>, JsonSerializer<Object>> serializers = new HashMap();

    public JoynrListSerializer() {
        super(List.class, false);
    }

    public void serialize(List<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartArray();
        for (Object elem : value) {
            if (elem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            Class<?> clazz = elem.getClass();
            JsonSerializer serializer = this.serializers.get(clazz);
            if (serializer == null) {
                serializer = provider.findTypedValueSerializer(clazz, false, null);
            }
            serializer.serialize(elem, jgen, provider);
        }
        jgen.writeEndArray();
    }

    public void serializeWithType(List<?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(value, jgen, provider);
    }
}

