/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import io.joynr.generator.IJoynrGenerator;
import io.joynr.generator.communicationmodel.CommunicationModelGenerator;
import io.joynr.generator.filter.FilterGenerator;
import io.joynr.generator.interfaces.InterfaceGenerator;
import io.joynr.generator.provider.ProviderGenerator;
import io.joynr.generator.proxy.ProxyGenerator;
import io.joynr.generator.templates.util.SupportedFrancaFeatureChecker;
import io.joynr.generator.util.JavaTemplateFactory;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FModel;

public class JoynrJavaGenerator
implements IJoynrGenerator {
    @Inject
    private InterfaceGenerator interfacesGenerator;
    @Inject
    private CommunicationModelGenerator communicationModelGenerator;
    @Inject
    private ProxyGenerator proxyGenerator;
    @Inject
    private ProviderGenerator providerGenerator;
    @Inject
    private FilterGenerator filterGenerator;
    @Inject
    @Extension
    private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;

    public String getLanguageId() {
        return "java";
    }

    public Module getGeneratorModule() {
        return new AbstractModule(){

            protected void configure() {
                FactoryModuleBuilder _factoryModuleBuilder = new FactoryModuleBuilder();
                Module _build = _factoryModuleBuilder.build(JavaTemplateFactory.class);
                this.install(_build);
            }
        };
    }

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        URI _uRI = input.getURI();
        String _fileExtension = _uRI.fileExtension();
        boolean isFrancaIDLResource = _fileExtension.equals("fidl");
        Preconditions.checkArgument((boolean)isFrancaIDLResource, (Object)("Unknown input: " + input));
        EList _contents = input.getContents();
        EObject _get = (EObject)_contents.get(0);
        FModel fModel = (FModel)_get;
        SupportedFrancaFeatureChecker.checkModel((FModel)fModel);
        EList _interfaces = fModel.getInterfaces();
        for (FInterface fInterface : _interfaces) {
            this.interfacesGenerator.doGenerate(fInterface, fsa);
            this.proxyGenerator.doGenerate(fInterface, fsa);
            this.providerGenerator.doGenerate(fInterface, fsa);
            this.filterGenerator.doGenerate(fInterface, fsa);
        }
        this.communicationModelGenerator.doGenerate(fModel, fsa);
    }

    public Iterable<FInterface> findAllFInterfaces(Resource resource) {
        HashSet<FInterface> result = new HashSet<FInterface>();
        ResourceSet rs = resource.getResourceSet();
        EList _resources = rs.getResources();
        for (Resource r : _resources) {
            EList _contents = r.getContents();
            for (EObject c : _contents) {
                if (!(c instanceof FModel)) continue;
                EList _interfaces = ((FModel)c).getInterfaces();
                result.addAll((Collection<FInterface>)_interfaces);
            }
        }
        return result;
    }

    public Iterable<FCompoundType> findAllComplexTypes(Resource resource) {
        HashSet<FCompoundType> result = new HashSet<FCompoundType>();
        ResourceSet rs = resource.getResourceSet();
        EList _resources = rs.getResources();
        for (Resource r : _resources) {
            EList _contents = r.getContents();
            for (EObject c : _contents) {
                if (!(c instanceof FModel)) continue;
                Iterable _compoundDataTypes = this._joynrJavaGeneratorExtensions.getCompoundDataTypes((FModel)c);
                Iterables.addAll(result, (Iterable)_compoundDataTypes);
            }
        }
        return result;
    }

    public void setParameters(Map<String, String> parameter) {
        Set<String> _keySet = parameter.keySet();
        boolean _contains = _keySet.contains("jee");
        if (_contains) {
            this._joynrJavaGeneratorExtensions.activateJeeExtension();
        }
    }

    public Set<String> supportedParameters() {
        return Sets.newHashSet((Object[])new String[]{"jee"});
    }
}

