/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.communicationmodel;

import com.google.inject.Inject;
import io.joynr.generator.communicationmodel.ComplexTypeTemplate;
import io.joynr.generator.communicationmodel.EnumTypeTemplate;
import io.joynr.generator.communicationmodel.MapTypeTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.templates.util.TypeUtil;
import io.joynr.generator.util.JavaTemplateFactory;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FModel;
import org.franca.core.franca.FModelElement;
import org.franca.core.franca.FType;

public class CommunicationModelGenerator {
    @Inject
    @Extension
    private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
    @Inject
    @Extension
    private TypeUtil _typeUtil;
    @Inject
    @Extension
    private NamingUtil _namingUtil;
    @Inject
    private JavaTemplateFactory templateFactory;

    public void doGenerate(FModel fModel, IFileSystemAccess fsa) {
        Iterable _compoundDataTypes = this._joynrJavaGeneratorExtensions.getCompoundDataTypes(fModel);
        for (Object type : _compoundDataTypes) {
            String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix((FModelElement)type, File.separator);
            String path = _packagePathWithJoynrPrefix + File.separator;
            boolean _isPartOfTypeCollection = this._typeUtil.isPartOfTypeCollection((FType)type);
            if (_isPartOfTypeCollection) {
                String _path = path;
                String _typeCollectionName = this._typeUtil.getTypeCollectionName((FType)type);
                String _plus = _typeCollectionName + File.separator;
                path = _path + _plus;
            }
            ComplexTypeTemplate complexTypeTemplate = this.templateFactory.createComplexTypeTemplate((FCompoundType)type);
            String _joynrName = this._namingUtil.joynrName((FType)type);
            String _plus_1 = path + _joynrName;
            String _plus_2 = _plus_1 + ".java";
            this._joynrJavaGeneratorExtensions.generateFile(fsa, _plus_2, complexTypeTemplate);
        }
        Iterable _enumDataTypes = this._joynrJavaGeneratorExtensions.getEnumDataTypes(fModel);
        for (FEnumerationType type_1 : _enumDataTypes) {
            String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix((FModelElement)type_1, File.separator);
            String path = _packagePathWithJoynrPrefix + File.separator;
            boolean _isPartOfTypeCollection = this._typeUtil.isPartOfTypeCollection((FType)type_1);
            if (_isPartOfTypeCollection) {
                String _path = path;
                String _typeCollectionName = this._typeUtil.getTypeCollectionName((FType)type_1);
                String _plus = _typeCollectionName + File.separator;
                path = _path + _plus;
            }
            EnumTypeTemplate enumTypeTemplate = this.templateFactory.createEnumTypeTemplate(type_1);
            String _joynrName = this._namingUtil.joynrName((FType)type_1);
            String _plus_1 = path + _joynrName;
            String _plus_2 = _plus_1 + ".java";
            this._joynrJavaGeneratorExtensions.generateFile(fsa, _plus_2, enumTypeTemplate);
        }
        Iterable _mapDataTypes = this._joynrJavaGeneratorExtensions.getMapDataTypes(fModel);
        for (FMapType type_2 : _mapDataTypes) {
            String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix((FModelElement)type_2, File.separator);
            String path = _packagePathWithJoynrPrefix + File.separator;
            boolean _isPartOfTypeCollection = this._typeUtil.isPartOfTypeCollection((FType)type_2);
            if (_isPartOfTypeCollection) {
                String _path = path;
                String _typeCollectionName = this._typeUtil.getTypeCollectionName((FType)type_2);
                String _plus = _typeCollectionName + File.separator;
                path = _path + _plus;
            }
            MapTypeTemplate mapTypeTemplate = this.templateFactory.createMapTypeTemplate(type_2);
            String _joynrName = this._namingUtil.joynrName((FType)type_2);
            String _plus_1 = path + _joynrName;
            String _plus_2 = _plus_1 + ".java";
            this._joynrJavaGeneratorExtensions.generateFile(fsa, _plus_2, mapTypeTemplate);
        }
    }
}

