/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.communicationmodel;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.joynr.generator.templates.CompoundTypeTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FField;
import org.franca.core.franca.FModelElement;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FTypedElement;

public class ComplexTypeTemplate
extends CompoundTypeTemplate {
    @Inject
    @Extension
    private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;
    @Inject
    @Extension
    private TemplateBase _templateBase;
    @Inject
    @Extension
    private NamingUtil _namingUtil;

    @Inject
    public ComplexTypeTemplate(@Assisted FCompoundType type) {
        super(type);
    }

    public CharSequence generate() {
        boolean _not_3;
        EList _members_6;
        boolean _isEmpty_1;
        boolean _not_2;
        boolean _not_1;
        StringConcatenation _xblockexpression = null;
        String typeName = this._namingUtil.joynrName((FType)this.type);
        String complexTypePackageName = this._joynrJavaGeneratorExtensions.buildPackagePath((FType)this.type, ".", true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t\t");
        CharSequence _warning = this._templateBase.warning();
        _builder.append((Object)_warning, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)complexTypePackageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import java.io.Serializable;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import io.joynr.subtypes.JoynrType;");
        _builder.newLine();
        _builder.newLine();
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(this.type);
        for (String member : _requiredIncludesFor) {
            _builder.append((Object)"import ");
            _builder.append((Object)member, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        boolean _hasArrayMembers = this._joynrJavaGeneratorExtensions.hasArrayMembers(this.type);
        if (_hasArrayMembers) {
            _builder.append((Object)"import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;");
            _builder.newLine();
        }
        _builder.append((Object)"import com.fasterxml.jackson.annotation.JsonProperty;");
        _builder.newLine();
        _builder.append((Object)"import com.fasterxml.jackson.annotation.JsonIgnore;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.");
        _builder.newLine();
        _builder.append((Object)"//       The compiler will generate a serialVersionUID based on the class and its members");
        _builder.newLine();
        _builder.append((Object)"//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),");
        _builder.newLine();
        _builder.append((Object)"//       which is probably more restrictive than what we want.");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        CharSequence _appendJavadocSummaryAndWriteSeeAndDescription = this._joynrJavaGeneratorExtensions.appendJavadocSummaryAndWriteSeeAndDescription((FModelElement)this.type, " *");
        _builder.append((Object)_appendJavadocSummaryAndWriteSeeAndDescription, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@SuppressWarnings(\"serial\")");
        _builder.newLine();
        _builder.append((Object)"public class ");
        _builder.append((Object)typeName, "");
        boolean _hasExtendsDeclaration = this._javaTypeUtil.hasExtendsDeclaration(this.type);
        if (_hasExtendsDeclaration) {
            _builder.append((Object)" extends ");
            FCompoundType _extendedType = this._javaTypeUtil.getExtendedType(this.type);
            String _typeName = this._javaTypeUtil.getTypeName((FType)_extendedType);
            _builder.append((Object)_typeName, "");
        }
        _builder.append((Object)" implements Serializable, JoynrType {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final int MAJOR_VERSION = ");
        _builder.append((Object)this.majorVersion, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final int MINOR_VERSION = ");
        _builder.append((Object)this.minorVersion, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        EList _members = this._javaTypeUtil.getMembers(this.type);
        for (FField member_1 : _members) {
            _builder.append((Object)"\t");
            String _typeName_1 = this._javaTypeUtil.getTypeName((FTypedElement)member_1);
            String memberType = _typeName_1.replace("::", "__");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"@JsonProperty(\"");
            String _joynrName = this._namingUtil.joynrName(member_1);
            _builder.append((Object)_joynrName, "\t");
            _builder.append((Object)"\")");
            _builder.newLineIfNotEmpty();
            boolean _isArray = this._javaTypeUtil.isArray((FTypedElement)member_1);
            if (_isArray) {
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append((Object)memberType, "\t");
                _builder.append((Object)" ");
                String _joynrName_1 = this._namingUtil.joynrName(member_1);
                _builder.append((Object)_joynrName_1, "\t");
                _builder.append((Object)" = {};");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"private ");
            _builder.append((Object)memberType, "\t");
            _builder.append((Object)" ");
            String _joynrName_2 = this._namingUtil.joynrName(member_1);
            _builder.append((Object)_joynrName_2, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Default Constructor");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)typeName, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        EList _members_1 = this._javaTypeUtil.getMembers(this.type);
        for (FField member_2 : _members_1) {
            boolean _isArray_1 = this._javaTypeUtil.isArray((FTypedElement)member_2);
            boolean _not = !_isArray_1;
            if (!_not) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _joynrName_3 = this._namingUtil.joynrName(member_2);
            _builder.append((Object)_joynrName_3, "\t\t");
            _builder.append((Object)" = ");
            String _defaultValue = this._javaTypeUtil.getDefaultValue((FTypedElement)member_2);
            _builder.append((Object)_defaultValue, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        String _firstLower = StringExtensions.toFirstLower((String)typeName);
        String copyObjName = _firstLower + "Obj";
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Copy constructor");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param ");
        _builder.append((Object)copyObjName, "\t ");
        _builder.append((Object)" reference to the object to be copied");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)typeName, "\t");
        _builder.append((Object)"(");
        _builder.append((Object)typeName, "\t");
        _builder.append((Object)" ");
        _builder.append((Object)copyObjName, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        boolean _hasExtendsDeclaration_1 = this._javaTypeUtil.hasExtendsDeclaration(this.type);
        if (_hasExtendsDeclaration_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"super(");
            _builder.append((Object)copyObjName, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        EList _members_2 = this._javaTypeUtil.getMembers(this.type);
        for (FField member_3 : _members_2) {
            boolean _isArray_2 = this._javaTypeUtil.isArray((FTypedElement)member_3);
            if (_isArray_2) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.");
                String _joynrName_4 = this._namingUtil.joynrName(member_3);
                _builder.append((Object)_joynrName_4, "\t\t");
                _builder.append((Object)" = ");
                _builder.append((Object)copyObjName, "\t\t");
                _builder.append((Object)".");
                String _joynrName_5 = this._namingUtil.joynrName(member_3);
                _builder.append((Object)_joynrName_5, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            boolean _or = false;
            FTypeRef _type = member_3.getType();
            boolean _isCompound = this._javaTypeUtil.isCompound(_type);
            if (_isCompound) {
                _or = true;
            } else {
                boolean _isMap;
                FTypeRef _type_1 = member_3.getType();
                _or = _isMap = this._javaTypeUtil.isMap(_type_1);
            }
            if (_or) {
                _builder.append((Object)"\t\t");
                FTypeRef _type_2 = member_3.getType();
                String memberType_1 = this._javaTypeUtil.getTypeName(_type_2);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this.");
                String _joynrName_6 = this._namingUtil.joynrName(member_3);
                _builder.append((Object)_joynrName_6, "\t\t");
                _builder.append((Object)" = new ");
                _builder.append((Object)memberType_1, "\t\t");
                _builder.append((Object)"(");
                _builder.append((Object)copyObjName, "\t\t");
                _builder.append((Object)".");
                String _joynrName_7 = this._namingUtil.joynrName(member_3);
                _builder.append((Object)_joynrName_7, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _joynrName_8 = this._namingUtil.joynrName(member_3);
            _builder.append((Object)_joynrName_8, "\t\t");
            _builder.append((Object)" = ");
            _builder.append((Object)copyObjName, "\t\t");
            _builder.append((Object)".");
            String _joynrName_9 = this._namingUtil.joynrName(member_3);
            _builder.append((Object)_joynrName_9, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        Iterable _membersRecursive = this._javaTypeUtil.getMembersRecursive((FType)this.type);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_membersRecursive);
        boolean bl = _not_1 = !_isEmpty;
        if (_not_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"* Parameterized constructor");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            Iterable _membersRecursive_1 = this._javaTypeUtil.getMembersRecursive((FType)this.type);
            for (Object member_4 : _membersRecursive_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)" ");
                String _appendJavadocParameter = this._joynrJavaGeneratorExtensions.appendJavadocParameter((FTypedElement)member_4, "*");
                _builder.append((Object)_appendJavadocParameter, "\t ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            boolean _hasArrayMembers_1 = this._joynrJavaGeneratorExtensions.hasArrayMembers(this.type);
            if (_hasArrayMembers_1) {
                _builder.append((Object)"@SuppressFBWarnings(value = \"EI_EXPOSE_REP2\", justification = \"joynr object not used for storing internal state\")");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            _builder.append((Object)typeName, "\t");
            _builder.append((Object)"(");
            _builder.newLineIfNotEmpty();
            Iterable _membersRecursive_2 = this._javaTypeUtil.getMembersRecursive((FType)this.type);
            boolean _hasElements = false;
            for (FField member_5 : _membersRecursive_2) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t");
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                String _typeName_2 = this._javaTypeUtil.getTypeName((FTypedElement)member_5);
                String _replace = _typeName_2.replace("::", "__");
                _builder.append((Object)_replace, "\t\t");
                _builder.append((Object)" ");
                String _joynrName_10 = this._namingUtil.joynrName(member_5);
                _builder.append((Object)_joynrName_10, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)") {");
            _builder.newLine();
            boolean _hasExtendsDeclaration_2 = this._javaTypeUtil.hasExtendsDeclaration(this.type);
            if (_hasExtendsDeclaration_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"super(");
                _builder.newLine();
                FCompoundType _extendedType_1 = this._javaTypeUtil.getExtendedType(this.type);
                Iterable _membersRecursive_3 = this._javaTypeUtil.getMembersRecursive((FType)_extendedType_1);
                boolean _hasElements_1 = false;
                for (FField member_6 : _membersRecursive_3) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t\t\t\t");
                    }
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    String _joynrName_11 = this._namingUtil.joynrName(member_6);
                    _builder.append((Object)_joynrName_11, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)");");
                _builder.newLine();
            }
            EList _members_3 = this._javaTypeUtil.getMembers(this.type);
            for (FField member_7 : _members_3) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                String _joynrName_12 = this._namingUtil.joynrName(member_7);
                _builder.append((Object)_joynrName_12, "\t\t");
                _builder.append((Object)" = ");
                String _joynrName_13 = this._namingUtil.joynrName(member_7);
                _builder.append((Object)_joynrName_13, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        EList _members_4 = this._javaTypeUtil.getMembers(this.type);
        for (FField member_8 : _members_4) {
            _builder.append((Object)"\t");
            String _typeName_3 = this._javaTypeUtil.getTypeName((FTypedElement)member_8);
            String memberType_2 = _typeName_3.replace("::", "__");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String memberName = this._namingUtil.joynrName(member_8);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"* Gets ");
            String _firstUpper = StringExtensions.toFirstUpper((String)memberName);
            _builder.append((Object)_firstUpper, "\t ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"* @return ");
            CharSequence _appendJavadocComment = this._joynrJavaGeneratorExtensions.appendJavadocComment((FModelElement)member_8, "* ");
            _builder.append((Object)_appendJavadocComment, "\t ");
            FTypeRef _type_3 = member_8.getType();
            boolean _isTypeDef = this._javaTypeUtil.isTypeDef(_type_3);
            if (_isTypeDef) {
                _builder.append((Object)" (type resolved from modeled Franca typedef ");
                FTypeRef _type_4 = member_8.getType();
                String _joynrName_14 = this._namingUtil.joynrName(_type_4);
                _builder.append((Object)_joynrName_14, "\t ");
                _builder.append((Object)" as ");
                FTypeRef _type_5 = member_8.getType();
                FTypeDef _typeDefType = this._javaTypeUtil.getTypeDefType(_type_5);
                FTypeRef _actualType = _typeDefType.getActualType();
                String _typeName_4 = this._javaTypeUtil.getTypeName(_actualType);
                _builder.append((Object)_typeName_4, "\t ");
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            boolean _isArray_3 = this._javaTypeUtil.isArray((FTypedElement)member_8);
            if (_isArray_3) {
                _builder.append((Object)"@SuppressFBWarnings(value = \"EI_EXPOSE_REP\", justification = \"joynr object not used for storing internal state\")");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"@JsonIgnore");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            _builder.append((Object)memberType_2, "\t");
            _builder.append((Object)" get");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)memberName);
            _builder.append((Object)_firstUpper_1, "\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this.");
            String _joynrName_15 = this._namingUtil.joynrName(member_8);
            _builder.append((Object)_joynrName_15, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"* Sets ");
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)memberName);
            _builder.append((Object)_firstUpper_2, "\t ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            String _appendJavadocParameter_1 = this._joynrJavaGeneratorExtensions.appendJavadocParameter((FTypedElement)member_8, "*");
            _builder.append((Object)_appendJavadocParameter_1, "\t ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            boolean _isArray_4 = this._javaTypeUtil.isArray((FTypedElement)member_8);
            if (_isArray_4) {
                _builder.append((Object)"@SuppressFBWarnings(value = \"EI_EXPOSE_REP2\", justification = \"joynr object not used for storing internal state\")");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"@JsonIgnore");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void set");
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)memberName);
            _builder.append((Object)_firstUpper_3, "\t");
            _builder.append((Object)"(");
            _builder.append((Object)memberType_2, "\t");
            _builder.append((Object)" ");
            String _joynrName_16 = this._namingUtil.joynrName(member_8);
            _builder.append((Object)_joynrName_16, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _joynrName_17 = this._namingUtil.joynrName(member_8);
            _builder.append((Object)_joynrName_17, "\t\t");
            _builder.append((Object)" = ");
            String _joynrName_18 = this._namingUtil.joynrName(member_8);
            _builder.append((Object)_joynrName_18, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Stringifies the class");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return stringified class content");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"");
        _builder.append((Object)typeName, "\t\t");
        _builder.append((Object)" [\"");
        _builder.newLineIfNotEmpty();
        boolean _hasExtendsDeclaration_3 = this._javaTypeUtil.hasExtendsDeclaration(this.type);
        if (_hasExtendsDeclaration_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"+ super.toString() + \", \"");
            _builder.newLine();
        }
        EList _members_5 = this._javaTypeUtil.getMembers(this.type);
        boolean _hasElements_2 = false;
        for (FField member_9 : _members_5) {
            if (!_hasElements_2) {
                _hasElements_2 = true;
            } else {
                _builder.appendImmediate((Object)" + \", \"", "\t\t");
            }
            boolean _isArray_5 = this._javaTypeUtil.isArray((FTypedElement)member_9);
            if (_isArray_5) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"+ \"");
                String _joynrName_19 = this._namingUtil.joynrName(member_9);
                _builder.append((Object)_joynrName_19, "\t\t");
                _builder.append((Object)"=\" + java.util.Arrays.toString(this.");
                String _joynrName_20 = this._namingUtil.joynrName(member_9);
                _builder.append((Object)_joynrName_20, "\t\t");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"+ \"");
            String _joynrName_21 = this._namingUtil.joynrName(member_9);
            _builder.append((Object)_joynrName_21, "\t\t");
            _builder.append((Object)"=\" + this.");
            String _joynrName_22 = this._namingUtil.joynrName(member_9);
            _builder.append((Object)_joynrName_22, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"+ \"]\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Check for equality");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param obj Reference to the object to compare to");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return true, if objects are equal, false otherwise");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean equals(Object obj) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this == obj)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (obj == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (getClass() != obj.getClass())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        boolean _hasExtendsDeclaration_4 = this._javaTypeUtil.hasExtendsDeclaration(this.type);
        if (_hasExtendsDeclaration_4) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (!super.equals(obj))");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return false;");
            _builder.newLine();
        }
        boolean bl2 = _not_2 = !(_isEmpty_1 = (_members_6 = this._javaTypeUtil.getMembers(this.type)).isEmpty());
        if (_not_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)typeName, "\t\t");
            _builder.append((Object)" other = (");
            _builder.append((Object)typeName, "\t\t");
            _builder.append((Object)") obj;");
            _builder.newLineIfNotEmpty();
        }
        EList _members_7 = this._javaTypeUtil.getMembers(this.type);
        for (FField member_10 : _members_7) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _joynrName_23 = this._namingUtil.joynrName(member_10);
            _builder.append((Object)_joynrName_23, "\t\t");
            _builder.append((Object)" == null) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (other.");
            String _joynrName_24 = this._namingUtil.joynrName(member_10);
            _builder.append((Object)_joynrName_24, "\t\t\t");
            _builder.append((Object)" != null) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return false;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            FTypeRef _type_6 = member_10.getType();
            boolean _isByteBuffer = this._javaTypeUtil.isByteBuffer(_type_6);
            if (_isByteBuffer) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"} else if (!java.util.Arrays.equals(this.");
                String _joynrName_25 = this._namingUtil.joynrName(member_10);
                _builder.append((Object)_joynrName_25, "\t\t");
                _builder.append((Object)", other.");
                String _joynrName_26 = this._namingUtil.joynrName(member_10);
                _builder.append((Object)_joynrName_26, "\t\t");
                _builder.append((Object)")){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                continue;
            }
            boolean _isArray_6 = this._javaTypeUtil.isArray((FTypedElement)member_10);
            if (_isArray_6) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"} else if (!java.util.Arrays.deepEquals(this.");
                String _joynrName_27 = this._namingUtil.joynrName(member_10);
                _builder.append((Object)_joynrName_27, "\t\t");
                _builder.append((Object)", other.");
                String _joynrName_28 = this._namingUtil.joynrName(member_10);
                _builder.append((Object)_joynrName_28, "\t\t");
                _builder.append((Object)")){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return false;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                continue;
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"} else if (!this.");
            String _joynrName_29 = this._namingUtil.joynrName(member_10);
            _builder.append((Object)_joynrName_29, "\t\t");
            _builder.append((Object)".equals(other.");
            String _joynrName_30 = this._namingUtil.joynrName(member_10);
            _builder.append((Object)_joynrName_30, "\t\t");
            _builder.append((Object)")){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return false;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Calculate code for hashing based on member contents");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return The calculated hash code");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int hashCode() {");
        _builder.newLine();
        boolean _hasExtendsDeclaration_5 = this._javaTypeUtil.hasExtendsDeclaration(this.type);
        if (_hasExtendsDeclaration_5) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"int result = super.hashCode();");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"int result = 1;");
            _builder.newLine();
        }
        EList _members_8 = this._javaTypeUtil.getMembers(this.type);
        boolean _isEmpty_2 = _members_8.isEmpty();
        boolean bl3 = _not_3 = !_isEmpty_2;
        if (_not_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"final int prime = 31;");
            _builder.newLine();
        }
        EList _members_9 = this._javaTypeUtil.getMembers(this.type);
        for (FField member_11 : _members_9) {
            boolean _isArray_7;
            boolean _or_1 = false;
            FTypeRef _type_7 = member_11.getType();
            boolean _isByteBuffer_1 = this._javaTypeUtil.isByteBuffer(_type_7);
            _or_1 = _isByteBuffer_1 ? true : (_isArray_7 = this._javaTypeUtil.isArray((FTypedElement)member_11));
            if (_or_1) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"result = prime * result + ((this.");
                String _joynrName_31 = this._namingUtil.joynrName(member_11);
                _builder.append((Object)_joynrName_31, "\t\t");
                _builder.append((Object)" == null) ? 0 : java.util.Arrays.hashCode(this.");
                String _joynrName_32 = this._namingUtil.joynrName(member_11);
                _builder.append((Object)_joynrName_32, "\t\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"result = prime * result + ((this.");
            String _joynrName_33 = this._namingUtil.joynrName(member_11);
            _builder.append((Object)_joynrName_33, "\t\t");
            _builder.append((Object)" == null) ? 0 : this.");
            String _joynrName_34 = this._namingUtil.joynrName(member_11);
            _builder.append((Object)_joynrName_34, "\t\t");
            _builder.append((Object)".hashCode());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

