/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.communicationmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.joynr.generator.templates.EnumTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FExpression;
import org.franca.core.franca.FModelElement;
import org.franca.core.franca.FType;

public class EnumTypeTemplate
extends EnumTemplate {
    @Inject
    @Extension
    private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;
    @Inject
    @Extension
    private NamingUtil _namingUtil;
    @Inject
    @Extension
    private TemplateBase _templateBase;

    @Inject
    public EnumTypeTemplate(@Assisted FEnumerationType type) {
        super(type);
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        String packagePath = this._joynrJavaGeneratorExtensions.buildPackagePath((FType)this.type, ".", true);
        _builder.newLineIfNotEmpty();
        CharSequence _warning = this._templateBase.warning();
        _builder.append((Object)_warning, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)packagePath, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.HashMap;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map.Entry;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateEnumCode = this.generateEnumCode();
        _builder.append((Object)_generateEnumCode, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateEnumCode() {
        StringConcatenation _builder = new StringConcatenation();
        String typeName = this._namingUtil.joynrName((FType)this.type);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        CharSequence _appendJavadocSummaryAndWriteSeeAndDescription = this._joynrJavaGeneratorExtensions.appendJavadocSummaryAndWriteSeeAndDescription((FModelElement)this.type, " *");
        _builder.append((Object)_appendJavadocSummaryAndWriteSeeAndDescription, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public enum ");
        _builder.append((Object)typeName, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        EList _enumElementsAndBaseEnumElements = this._javaTypeUtil.getEnumElementsAndBaseEnumElements(this.type);
        boolean _hasElements = false;
        for (FEnumerator enumValue : _enumElementsAndBaseEnumElements) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            CharSequence _appendJavadocComment = this._joynrJavaGeneratorExtensions.appendJavadocComment((FModelElement)enumValue, "* ");
            _builder.append((Object)_appendJavadocComment, "\t ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            String _joynrName = this._namingUtil.joynrName(enumValue);
            _builder.append((Object)_joynrName, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final int MAJOR_VERSION = ");
        _builder.append((Object)this.majorVersion, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final int MINOR_VERSION = ");
        _builder.append((Object)this.minorVersion, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"static final Map<Integer, ");
        _builder.append((Object)typeName, "\t");
        _builder.append((Object)"> ordinalToEnumValues = new HashMap<>();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static{");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        int ordinal = -1;
        _builder.newLineIfNotEmpty();
        EList _enumElementsAndBaseEnumElements_1 = this._javaTypeUtil.getEnumElementsAndBaseEnumElements(this.type);
        for (FEnumerator enumValue_1 : _enumElementsAndBaseEnumElements_1) {
            _builder.append((Object)"\t\t");
            String _xblockexpression = null;
            Integer _xifexpression = null;
            FExpression _value = enumValue_1.getValue();
            String _enumeratorValue = this._javaTypeUtil.getEnumeratorValue(_value);
            boolean _equals = Objects.equal((Object)_enumeratorValue, null);
            if (_equals) {
                _xifexpression = ordinal + 1;
            } else {
                FExpression _value_1 = enumValue_1.getValue();
                String _enumeratorValue_1 = this._javaTypeUtil.getEnumeratorValue(_value_1);
                _xifexpression = Integer.valueOf(_enumeratorValue_1);
            }
            ordinal = _xifexpression;
            _xblockexpression = "";
            _builder.append((Object)_xblockexpression, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"ordinalToEnumValues.put(");
            _builder.append((Object)ordinal, "\t\t");
            _builder.append((Object)", ");
            String _joynrName_1 = this._namingUtil.joynrName(enumValue_1);
            _builder.append((Object)_joynrName_1, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Get the matching enum for an ordinal number");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param ordinal The ordinal number");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return The matching enum for the given ordinal number");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        _builder.append((Object)typeName, "\t");
        _builder.append((Object)" getEnumValue(Integer ordinal) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ordinalToEnumValues.get(ordinal);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Get the matching ordinal number for this enum");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return The ordinal number representing this enum");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Integer getOrdinal() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// TODO should we use a bidirectional map from a third-party library?");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Integer ordinal = null;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for(Entry<Integer, ");
        _builder.append((Object)typeName, "\t\t");
        _builder.append((Object)"> entry : ordinalToEnumValues.entrySet()) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if(this == entry.getValue()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"ordinal = entry.getKey();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ordinal;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }
}

