/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.interfaces;

import com.google.inject.Inject;
import io.joynr.generator.interfaces.InterfaceAsyncTemplate;
import io.joynr.generator.interfaces.InterfaceBroadcastTemplate;
import io.joynr.generator.interfaces.InterfaceFireAndForgetTemplate;
import io.joynr.generator.interfaces.InterfaceSubscriptionTemplate;
import io.joynr.generator.interfaces.InterfaceSyncTemplate;
import io.joynr.generator.interfaces.InterfacesTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTemplateFactory;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FModelElement;

public class InterfaceGenerator {
    @Inject
    @Extension
    private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
    @Inject
    @Extension
    private NamingUtil _namingUtil;
    @Inject
    private JavaTemplateFactory templateFactory;

    public void doGenerate(FInterface serviceInterface, IFileSystemAccess fsa) {
        EList _broadcasts;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix((FModelElement)serviceInterface, File.separator);
        String path = _packagePathWithJoynrPrefix + File.separator;
        String serviceName = this._namingUtil.joynrName(serviceInterface);
        InterfacesTemplate interfacesTemplate = this.templateFactory.createInterfacesTemplate(serviceInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + ".java", interfacesTemplate);
        InterfaceSyncTemplate interfaceSyncTemplate = this.templateFactory.createInterfaceSyncTemplate(serviceInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "Sync.java", interfaceSyncTemplate);
        InterfaceAsyncTemplate interfaceAsyncTemplate = this.templateFactory.createInterfaceAsyncTemplate(serviceInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "Async.java", interfaceAsyncTemplate);
        InterfaceFireAndForgetTemplate interfaceFireAndForgetTemplate = this.templateFactory.createInterfaceFireAndForgetTemplate(serviceInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "FireAndForget.java", interfaceFireAndForgetTemplate);
        EList _attributes = serviceInterface.getAttributes();
        int _size = _attributes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            InterfaceSubscriptionTemplate interfaceSubscriptionTemplate = this.templateFactory.createInterfaceSubscriptionTemplate(serviceInterface);
            this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "SubscriptionInterface.java", interfaceSubscriptionTemplate);
        }
        boolean bl2 = _greaterThan_1 = (_size_1 = (_broadcasts = serviceInterface.getBroadcasts()).size()) > 0;
        if (_greaterThan_1) {
            InterfaceBroadcastTemplate interfaceBroadcastTemplate = this.templateFactory.createInterfaceBroadcastTemplate(serviceInterface);
            this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "BroadcastInterface.java", interfaceBroadcastTemplate);
        }
    }
}

