/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.interfaces;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import io.joynr.generator.communicationmodel.EnumTypeTemplate;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTemplateFactory;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FModelElement;

public class InterfacesTemplate
extends InterfaceTemplate {
    @Inject
    @Extension
    private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
    @Inject
    @Extension
    private NamingUtil _namingUtil;
    @Inject
    @Extension
    private InterfaceUtil _interfaceUtil;
    @Inject
    @Extension
    private TemplateBase _templateBase;
    @Inject
    private JavaTemplateFactory templateFactory;

    public CharSequence generate() {
        String interfaceName;
        StringConcatenation _xblockexpression = null;
        String className = interfaceName = this._namingUtil.joynrName(this.francaIntf);
        String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix((FModelElement)this.francaIntf, ".");
        boolean hasMethodWithImplicitErrorEnum = this._interfaceUtil.hasMethodWithImplicitErrorEnum(this.francaIntf);
        HashMap methodToErrorEnumName = this._interfaceUtil.methodToErrorEnumName(this.francaIntf);
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _warning = this._templateBase.warning();
        _builder.append((Object)_warning, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        _builder.append((Object)packagePath, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        if (hasMethodWithImplicitErrorEnum) {
            _builder.append((Object)"import java.util.HashMap;");
            _builder.newLine();
            _builder.append((Object)"import java.util.Map;");
            _builder.newLine();
            _builder.append((Object)"import java.util.Map.Entry;");
            _builder.newLine();
        }
        _builder.newLine();
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(this.francaIntf);
        for (String datatype : _requiredIncludesFor) {
            _builder.append((Object)"import ");
            _builder.append((Object)datatype, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"//The current generator is not able to check wether some of the imports are acutally necessary for this specific interface.");
        _builder.newLine();
        _builder.append((Object)"//Therefore some imports migth be unused in this version of the interface.");
        _builder.newLine();
        _builder.append((Object)"//To prevent warnings @SuppressWarnings(\"unused\") is being used. ");
        _builder.newLine();
        _builder.append((Object)"//To prevent warnings about an unnecessary SuppressWarnings we have to import something that is not used. (e.g. TreeSet)");
        _builder.newLine();
        _builder.append((Object)"import java.util.TreeSet;");
        _builder.newLine();
        _builder.append((Object)"@SuppressWarnings(\"unused\")");
        _builder.newLine();
        _builder.append((Object)"public interface ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static String INTERFACE_NAME = \"");
        String _packagePathWithoutJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithoutJoynrPrefix((FModelElement)this.francaIntf, "/");
        _builder.append((Object)_packagePathWithoutJoynrPrefix, "\t");
        _builder.append((Object)"/");
        _builder.append((Object)interfaceName, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _methods = this._interfaceUtil.getMethods(this.francaIntf);
        for (FMethod method : _methods) {
            _builder.append((Object)"\t");
            FEnumerationType enumType = method.getErrors();
            _builder.newLineIfNotEmpty();
            boolean _notEquals = !Objects.equal((Object)enumType, null);
            if (!_notEquals) continue;
            _builder.append((Object)"\t");
            EnumTypeTemplate enumTypeTemplate = this.templateFactory.createEnumTypeTemplate(enumType);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _get = (String)methodToErrorEnumName.get(method);
            enumType.setName(_get);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _generateEnumCode = enumTypeTemplate.generateEnumCode();
            _builder.append((Object)_generateEnumCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

