/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.provider;

import com.google.inject.Inject;
import io.joynr.generator.provider.DefaultInterfaceProviderTemplate;
import io.joynr.generator.provider.InterfaceAbstractProviderTemplate;
import io.joynr.generator.provider.InterfaceProviderTemplate;
import io.joynr.generator.provider.InterfaceSubscriptionPublisherImplTemplate;
import io.joynr.generator.provider.InterfaceSubscriptionPublisherTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTemplateFactory;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FModelElement;

public class ProviderGenerator {
    @Inject
    @Extension
    private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
    @Inject
    @Extension
    private NamingUtil _namingUtil;
    @Inject
    private JavaTemplateFactory templateFactory;

    public void doGenerate(FInterface fInterface, IFileSystemAccess fsa) {
        String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix((FModelElement)fInterface, File.separator);
        String path = _packagePathWithJoynrPrefix + File.separator;
        String serviceName = this._namingUtil.joynrName(fInterface);
        InterfaceProviderTemplate interfaceProviderTemplate = this.templateFactory.createInterfaceProviderTemplate(fInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "Provider.java", interfaceProviderTemplate);
        DefaultInterfaceProviderTemplate defaultInterfaceProviderTemplate = this.templateFactory.createDefaultInterfaceProviderTemplate(fInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + "Default" + serviceName + "Provider.java", defaultInterfaceProviderTemplate);
        InterfaceAbstractProviderTemplate interfaceAbstractProviderTemplate = this.templateFactory.createInterfaceAbstractProviderTemplate(fInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "AbstractProvider.java", interfaceAbstractProviderTemplate);
        InterfaceSubscriptionPublisherTemplate subscriptionPublisherTemplate = this.templateFactory.createSubscriptionPublisherTemplate(fInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "SubscriptionPublisher.java", subscriptionPublisherTemplate);
        InterfaceSubscriptionPublisherImplTemplate subscriptionPublisherImplTemplate = this.templateFactory.createSubscriptionPublisherImplTemplate(fInterface);
        this._joynrJavaGeneratorExtensions.generateFile(fsa, path + serviceName + "SubscriptionPublisherImpl.java", subscriptionPublisherImplTemplate);
    }
}

