/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.util;

import com.google.inject.Inject;
import io.joynr.generator.templates.util.AbstractTypeUtil;
import io.joynr.generator.templates.util.BroadcastUtil;
import io.joynr.generator.templates.util.MethodUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FBasicTypeId;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FTypedElement;

public class JavaTypeUtil
extends AbstractTypeUtil {
    @Inject
    @Extension
    private MethodUtil _methodUtil;
    @Inject
    @Extension
    private BroadcastUtil _broadcastUtil;
    private Map<FBasicTypeId, String> primitiveDataTypeDefaultMap;

    public JavaTypeUtil() {
        HashMap<FBasicTypeId, String> primitiveDataTypeDefaultValue = new HashMap<FBasicTypeId, String>();
        primitiveDataTypeDefaultValue.put(FBasicTypeId.BOOLEAN, "false");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.INT8, "0");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT8, "0");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.INT16, "0");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT16, "0");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.INT32, "0");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT32, "0");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.INT64, "0L");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT64, "0l");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.FLOAT, "0f");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.DOUBLE, "0d");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.STRING, "\"\"");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.BYTE_BUFFER, "new Byte[0]");
        primitiveDataTypeDefaultValue.put(FBasicTypeId.UNDEFINED, "");
        Map _unmodifiableMap = Collections.unmodifiableMap(primitiveDataTypeDefaultValue);
        this.primitiveDataTypeDefaultMap = _unmodifiableMap;
    }

    public String getCommaSeperatedTypedOutputParameterList(Iterable<FArgument> arguments, boolean linebreak) {
        boolean _equals;
        StringBuilder returnStringBuilder = new StringBuilder();
        for (FArgument argument : arguments) {
            String _typeName = this.getTypeName((FTypedElement)argument);
            returnStringBuilder.append(_typeName);
            returnStringBuilder.append(" ");
            String _joynrName = this._namingUtil.joynrName(argument);
            returnStringBuilder.append(_joynrName);
            returnStringBuilder.append(",");
            if (linebreak) {
                returnStringBuilder.append("\n");
                continue;
            }
            returnStringBuilder.append(" ");
        }
        String returnString = returnStringBuilder.toString();
        int _length = returnString.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return "";
        }
        int _length_1 = returnString.length();
        int _minus = _length_1 - 2;
        return returnString.substring(0, _minus);
    }

    public String getCommaSeperatedTypedOutputParameterList(FMethod method) {
        Iterable _outputParameters = this._methodUtil.getOutputParameters(method);
        return this.getCommaSeperatedTypedOutputParameterList(_outputParameters, false);
    }

    public String getCommaSeperatedTypedOutputParameterList(FBroadcast broadcast) {
        Iterable _outputParameters = this._broadcastUtil.getOutputParameters(broadcast);
        return this.getCommaSeperatedTypedOutputParameterList(_outputParameters, false);
    }

    public String getCommaSeperatedTypedOutputParameterListLinebreak(FBroadcast broadcast) {
        Iterable _outputParameters = this._broadcastUtil.getOutputParameters(broadcast);
        return this.getCommaSeperatedTypedOutputParameterList(_outputParameters, true);
    }

    public String getCommaSeperatedUntypedInputParameterList(FMethod method) {
        Iterable _inputParameters = this._methodUtil.getInputParameters(method);
        return this.getCommaSeperatedUntypedParameterList(_inputParameters);
    }

    public String getCommaSeperatedUntypedOutputParameterList(FMethod method) {
        Iterable _outputParameters = this._methodUtil.getOutputParameters(method);
        return this.getCommaSeperatedUntypedParameterList(_outputParameters);
    }

    public String getCommaSeperatedUntypedOutputParameterList(FBroadcast broadcast) {
        Iterable _outputParameters = this._broadcastUtil.getOutputParameters(broadcast);
        return this.getCommaSeperatedUntypedParameterList(_outputParameters);
    }

    public String getCommaSeperatedUntypedParameterList(Iterable<FArgument> arguments) {
        boolean _equals;
        StringBuilder returnStringBuilder = new StringBuilder();
        for (FArgument argument : arguments) {
            String _joynrName = this._namingUtil.joynrName(argument);
            returnStringBuilder.append(_joynrName);
            returnStringBuilder.append(", ");
        }
        String returnString = returnStringBuilder.toString();
        int _length = returnString.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return "";
        }
        int _length_1 = returnString.length();
        int _minus = _length_1 - 2;
        return returnString.substring(0, _minus);
    }

    public String getCommaSeperatedTypedParameterList(FMethod method) {
        boolean _equals;
        StringBuilder returnStringBuilder = new StringBuilder();
        Iterable _inputParameters = this._methodUtil.getInputParameters(method);
        for (FArgument param : _inputParameters) {
            String _typeName = this.getTypeName((FTypedElement)param);
            returnStringBuilder.append(_typeName);
            returnStringBuilder.append(" ");
            String _joynrName = this._namingUtil.joynrName(param);
            returnStringBuilder.append(_joynrName);
            returnStringBuilder.append(", ");
        }
        String returnString = returnStringBuilder.toString();
        int _length = returnString.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return "";
        }
        int _length_1 = returnString.length();
        int _minus = _length_1 - 2;
        return returnString.substring(0, _minus);
    }

    public String getCommaSeperatedTypedFilterParameterList(FBroadcast broadcast) {
        boolean _equals;
        StringBuilder returnStringBuilder = new StringBuilder();
        ArrayList _filterParameters = this._broadcastUtil.getFilterParameters(broadcast);
        for (String filterParameter : _filterParameters) {
            returnStringBuilder.append("String ");
            returnStringBuilder.append(filterParameter);
            returnStringBuilder.append(", ");
        }
        String returnString = returnStringBuilder.toString();
        int _length = returnString.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return "";
        }
        int _length_1 = returnString.length();
        int _minus = _length_1 - 2;
        return returnString.substring(0, _minus);
    }

    public boolean isCompound(FType type) {
        if (type instanceof FTypeDef) {
            FTypeRef _actualType = ((FTypeDef)type).getActualType();
            return this.isCompound(_actualType);
        }
        return super.isCompound(type);
    }

    public FCompoundType getCompoundType(FType type) {
        if (type instanceof FTypeDef) {
            FTypeRef _actualType = ((FTypeDef)type).getActualType();
            return this.getCompoundType(_actualType);
        }
        return super.getCompoundType(type);
    }

    public boolean isPrimitive(FType type) {
        if (type instanceof FTypeDef) {
            FTypeRef _actualType = ((FTypeDef)type).getActualType();
            return this.isPrimitive(_actualType);
        }
        return super.isPrimitive(type);
    }

    public FBasicTypeId getPrimitive(FType type) {
        if (type instanceof FTypeDef) {
            FTypeRef _actualType = ((FTypeDef)type).getActualType();
            return this.getPrimitive(_actualType);
        }
        return super.getPrimitive(type);
    }

    public String getTypeName(FBasicTypeId datatype) {
        String _switchResult = null;
        if (datatype != null) {
            switch (datatype) {
                case BOOLEAN: {
                    _switchResult = "Boolean";
                    break;
                }
                case INT8: {
                    _switchResult = "Byte";
                    break;
                }
                case UINT8: {
                    _switchResult = "Byte";
                    break;
                }
                case INT16: {
                    _switchResult = "Short";
                    break;
                }
                case UINT16: {
                    _switchResult = "Short";
                    break;
                }
                case INT32: {
                    _switchResult = "Integer";
                    break;
                }
                case UINT32: {
                    _switchResult = "Integer";
                    break;
                }
                case INT64: {
                    _switchResult = "Long";
                    break;
                }
                case UINT64: {
                    _switchResult = "Long";
                    break;
                }
                case FLOAT: {
                    _switchResult = "Float";
                    break;
                }
                case DOUBLE: {
                    _switchResult = "Double";
                    break;
                }
                case STRING: {
                    _switchResult = "String";
                    break;
                }
                case BYTE_BUFFER: {
                    _switchResult = "Byte[]";
                    break;
                }
                default: {
                    String _name = datatype.getName();
                    String _plus = "Unsupported basic type: " + _name;
                    throw new IllegalArgumentException(_plus);
                }
            }
        } else {
            String _name = datatype.getName();
            String _plus = "Unsupported basic type: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    public String getTypeName(FType datatype) {
        boolean _isEnum = this.isEnum(datatype);
        if (_isEnum) {
            FEnumerationType _enumType = this.getEnumType(datatype);
            return this._namingUtil.joynrName((FType)_enumType);
        }
        boolean _isPrimitive = this.isPrimitive(datatype);
        if (_isPrimitive) {
            FBasicTypeId _primitive = this.getPrimitive(datatype);
            return this.getTypeName(_primitive);
        }
        boolean _isCompound = this.isCompound(datatype);
        if (_isCompound) {
            FCompoundType _compoundType = this.getCompoundType(datatype);
            return this._namingUtil.joynrName((FType)_compoundType);
        }
        boolean _isMap = this.isMap(datatype);
        if (_isMap) {
            FMapType _mapType = this.getMapType(datatype);
            return this._namingUtil.joynrName((FType)_mapType);
        }
        String _joynrName = this._namingUtil.joynrName(datatype);
        String _plus = "JavaTypeUtil.getTypeName: unsupported state, datatype " + _joynrName;
        String _plus_1 = _plus + " could not be mapped to an implementation datatype";
        throw new IllegalStateException(_plus_1);
    }

    public String getTypeNameForList(FBasicTypeId datatype) {
        String _typeName = this.getTypeName(datatype);
        String _objectDataTypeForPlainType = this.getObjectDataTypeForPlainType(_typeName);
        return _objectDataTypeForPlainType + "[]";
    }

    public String getTypeNameForList(FType datatype) {
        String _typeName = this.getTypeName(datatype);
        String _objectDataTypeForPlainType = this.getObjectDataTypeForPlainType(_typeName);
        return _objectDataTypeForPlainType + "[]";
    }

    public String getTypedParameterList(Iterable<FArgument> params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < IterableExtensions.size(params); ++i) {
            boolean _notEquals;
            FArgument param = ((FArgument[])Conversions.unwrapArray(params, FArgument.class))[i];
            String _typeName = this.getTypeName((FTypedElement)param);
            String _plus = _typeName + " ";
            String _joynrName = this._namingUtil.joynrName(param);
            String _plus_1 = _plus + _joynrName;
            sb.append(_plus_1);
            int _size = IterableExtensions.size(params);
            int _minus = _size - 1;
            boolean bl = _notEquals = i != _minus;
            if (!_notEquals) continue;
            sb.append(",\n");
        }
        return sb.toString();
    }

    public String getJavadocCommentsParameterListJavaRpc(FMethod method) {
        StringBuilder sb = new StringBuilder();
        Iterable params = this._methodUtil.getInputParameters(method);
        for (int i = 0; i < IterableExtensions.size((Iterable)params); ++i) {
            FArgument param = ((FArgument[])Conversions.unwrapArray((Object)params, FArgument.class))[i];
            String _joynrName = this._namingUtil.joynrName(param);
            String _plus = " * @param " + _joynrName;
            String _plus_1 = _plus + " the parameter ";
            String _joynrName_1 = this._namingUtil.joynrName(param);
            String _plus_2 = _plus_1 + _joynrName_1;
            String _plus_3 = _plus_2 + "\n";
            sb.append(_plus_3);
        }
        return sb.toString();
    }

    public String getDefaultValue(FTypedElement element) {
        boolean _isArray = this.isArray(element);
        if (_isArray) {
            return "{}";
        }
        FTypeRef _type = element.getType();
        return this.getDefaultValue(_type);
    }

    public String getDefaultValue(FTypeRef typeRef) {
        boolean _not;
        boolean _isMap_1;
        boolean _isMap = this.isMap(typeRef);
        if (_isMap) {
            String _joynrName = this._namingUtil.joynrName(typeRef);
            String _plus = "new " + _joynrName;
            return _plus + "()";
        }
        boolean _isTypeDef = this.isTypeDef(typeRef);
        if (_isTypeDef) {
            FTypeDef _typeDefType = this.getTypeDefType(typeRef);
            FTypeRef _actualType = _typeDefType.getActualType();
            return this.getDefaultValue(_actualType);
        }
        boolean _or = false;
        boolean _isCompound = this.isCompound(typeRef);
        _or = _isCompound ? true : (_isMap_1 = this.isMap(typeRef));
        if (_or) {
            FCompoundType _compoundType = this.getCompoundType(typeRef);
            String _joynrName_1 = this._namingUtil.joynrName((FType)_compoundType);
            String _plus_1 = "new " + _joynrName_1;
            return _plus_1 + "()";
        }
        boolean _isEnum = this.isEnum(typeRef);
        if (_isEnum) {
            FEnumerationType _enumType = this.getEnumType(typeRef);
            String _joynrName_2 = this._namingUtil.joynrName((FType)_enumType);
            String _plus_2 = _joynrName_2 + ".";
            FEnumerationType _enumType_1 = this.getEnumType(typeRef);
            EList _enumerators = _enumType_1.getEnumerators();
            FEnumerator _get = (FEnumerator)_enumerators.get(0);
            String _joynrName_3 = this._namingUtil.joynrName(_get);
            return _plus_2 + _joynrName_3;
        }
        FBasicTypeId _predefined = typeRef.getPredefined();
        boolean _containsKey = this.primitiveDataTypeDefaultMap.containsKey(_predefined);
        boolean bl = _not = !_containsKey;
        if (_not) {
            return "NaN";
        }
        boolean _isPrimitive = this.isPrimitive(typeRef);
        if (_isPrimitive) {
            FBasicTypeId _predefined_1 = typeRef.getPredefined();
            return this.primitiveDataTypeDefaultMap.get(_predefined_1);
        }
        return null;
    }
}

