/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.generator.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import io.joynr.generator.templates.util.BroadcastUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.JoynrGeneratorExtensions;
import io.joynr.generator.util.JavaTypeUtil;
import java.util.Iterator;
import java.util.TreeSet;
import javax.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FAnnotation;
import org.franca.core.franca.FAnnotationBlock;
import org.franca.core.franca.FAnnotationType;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FField;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FModelElement;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FTypedElement;

@Singleton
public class JoynrJavaGeneratorExtensions
extends JoynrGeneratorExtensions {
    @Inject
    @Extension
    private JavaTypeUtil _javaTypeUtil;
    @Inject
    @Extension
    private InterfaceUtil _interfaceUtil;
    @Inject
    @Extension
    private BroadcastUtil _broadcastUtil;
    private boolean jeeExtension = false;

    public String getNamespaceStarter(FInterface interfaceType) {
        UnmodifiableIterator _packageNames = this.getPackageNames((FModelElement)interfaceType);
        return this.getNamespaceStarter((Iterator<String>)_packageNames);
    }

    public String getNamespaceStarter(FType datatype) {
        UnmodifiableIterator _packageNames = this.getPackageNames((FModelElement)datatype);
        return this.getNamespaceStarter((Iterator<String>)_packageNames);
    }

    public String getNamespaceEnder(FInterface interfaceType) {
        UnmodifiableIterator _packageNames = this.getPackageNames((FModelElement)interfaceType);
        return this.getNamespaceEnder((Iterator<String>)_packageNames);
    }

    public String getNamespaceEnder(FType datatype) {
        UnmodifiableIterator _packageNames = this.getPackageNames((FModelElement)datatype);
        return this.getNamespaceEnder((Iterator<String>)_packageNames);
    }

    private String getNamespaceStarter(Iterator<String> packageList) {
        return this.getNamespaceStarterFromPackageList(packageList);
    }

    public String getNamespaceStarterFromPackageList(Iterator<String> packageList) {
        StringBuilder sb = new StringBuilder();
        while (packageList.hasNext()) {
            String _next = packageList.next();
            String _plus = "namespace " + _next;
            String _plus_1 = _plus + "{ ";
            sb.append(_plus_1);
        }
        return sb.toString();
    }

    private String getNamespaceEnder(Iterator<String> packageList) {
        return this.getNameSpaceEnderFromPackageList(packageList);
    }

    public String getNameSpaceEnderFromPackageList(Iterator<String> packageList) {
        StringBuilder sb = new StringBuilder();
        while (packageList.hasNext()) {
            String _next = packageList.next();
            String _plus = "} /* namespace " + _next;
            String _plus_1 = _plus + " */ ";
            sb.insert(0, _plus_1);
        }
        return sb.toString();
    }

    public Iterable<String> getRequiredIncludesFor(FCompoundType datatype) {
        return this.getRequiredIncludesFor(datatype, true);
    }

    public Iterable<String> getRequiredIncludesFor(FCompoundType datatype, boolean includingExendedType) {
        Iterable members = this._javaTypeUtil.getComplexMembers(datatype);
        TreeSet<String> typeList = new TreeSet<String>();
        boolean _hasExtendsDeclaration = this._javaTypeUtil.hasExtendsDeclaration(datatype);
        if (_hasExtendsDeclaration) {
            if (includingExendedType) {
                FCompoundType _extendedType = this._javaTypeUtil.getExtendedType(datatype);
                String _includeOf = this.getIncludeOf((FType)_extendedType);
                typeList.add(_includeOf);
            }
            FCompoundType _extendedType_1 = this._javaTypeUtil.getExtendedType(datatype);
            Iterable<String> _requiredIncludesFor = this.getRequiredIncludesFor(_extendedType_1, false);
            Iterables.addAll(typeList, _requiredIncludesFor);
        }
        for (FField member : members) {
            FTypeRef _type = member.getType();
            Object type = this._javaTypeUtil.getDatatype(_type);
            if (!(type instanceof FType)) continue;
            String _includeOf_1 = this.getIncludeOf((FType)type);
            typeList.add(_includeOf_1);
        }
        return typeList;
    }

    public Iterable<String> getRequiredIncludesFor(FInterface serviceInterface) {
        return this.getRequiredIncludesFor(serviceInterface, true, true, true, true, true, true);
    }

    public Iterable<String> getRequiredIncludesFor(FInterface serviceInterface, boolean methods, boolean readAttributes, boolean writeAttributes, boolean notifyAttributes, boolean broadcasts, boolean fireAndForget) {
        TreeSet<String> includeSet = new TreeSet<String>();
        InterfaceUtil.TypeSelector selector = InterfaceUtil.TypeSelector.defaultTypeSelector();
        selector.methods(methods);
        selector.fireAndForget(fireAndForget);
        selector.readAttributes(readAttributes);
        selector.writeAttributes(writeAttributes);
        selector.notifyAttributes(notifyAttributes);
        selector.broadcasts(broadcasts);
        Iterable _allComplexTypes = this._interfaceUtil.getAllComplexTypes(serviceInterface, selector);
        for (FType datatype : _allComplexTypes) {
            String include = this.getIncludeOf(datatype);
            boolean _notEquals = !Objects.equal((Object)include, null);
            if (!_notEquals) continue;
            includeSet.add(include);
        }
        return includeSet;
    }

    public Iterable<String> getRequiredIncludesFor(FBroadcast broadcast) {
        TreeSet<String> includeSet = new TreeSet<String>();
        Iterable _allComplexTypes = this._broadcastUtil.getAllComplexTypes(broadcast);
        for (FType datatype : _allComplexTypes) {
            String _includeOf = this.getIncludeOf(datatype);
            includeSet.add(_includeOf);
        }
        return includeSet;
    }

    public String ReformatComment(FAnnotation comment, String prefixForNewLines) {
        String _comment = comment.getComment();
        String _replaceAll = _comment.replaceAll("\\s+", " ");
        return _replaceAll.replaceAll("\n", "\n" + prefixForNewLines);
    }

    public CharSequence appendJavadocSummaryAndWriteSeeAndDescription(FModelElement element, String prefixForNewLines) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        FAnnotationBlock _comment = element.getComment();
        boolean bl = _notEquals = !Objects.equal((Object)_comment, null);
        if (_notEquals) {
            FAnnotationBlock _comment_1 = element.getComment();
            EList _elements = _comment_1.getElements();
            for (FAnnotation comment : _elements) {
                FAnnotationType _type = comment.getType();
                boolean _equals = Objects.equal((Object)_type, (Object)FAnnotationType.DESCRIPTION);
                if (!_equals) continue;
                _builder.append((Object)prefixForNewLines, "");
                _builder.append((Object)" ");
                String _ReformatComment = this.ReformatComment(comment, prefixForNewLines);
                _builder.append((Object)_ReformatComment, "");
                _builder.newLineIfNotEmpty();
            }
            FAnnotationBlock _comment_2 = element.getComment();
            EList _elements_1 = _comment_2.getElements();
            for (FAnnotation comment_1 : _elements_1) {
                FAnnotationType _type_2;
                boolean _equals_2;
                FAnnotationType _type_1 = comment_1.getType();
                boolean _equals_1 = Objects.equal((Object)_type_1, (Object)FAnnotationType.SEE);
                if (_equals_1) {
                    _builder.append((Object)prefixForNewLines, "");
                    _builder.append((Object)" @see ");
                    String _ReformatComment_1 = this.ReformatComment(comment_1, prefixForNewLines);
                    _builder.append((Object)_ReformatComment_1, "");
                    _builder.newLineIfNotEmpty();
                }
                if (!(_equals_2 = Objects.equal((Object)(_type_2 = comment_1.getType()), (Object)FAnnotationType.DETAILS))) continue;
                _builder.append((Object)prefixForNewLines, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)prefixForNewLines, "");
                _builder.append((Object)" ");
                String _ReformatComment_2 = this.ReformatComment(comment_1, prefixForNewLines);
                _builder.append((Object)_ReformatComment_2, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence appendJavadocComment(FModelElement element, String prefixForNewLines) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        FAnnotationBlock _comment = element.getComment();
        boolean bl = _notEquals = !Objects.equal((Object)_comment, null);
        if (_notEquals) {
            FAnnotationBlock _comment_1 = element.getComment();
            EList _elements = _comment_1.getElements();
            for (FAnnotation comment : _elements) {
                FAnnotationType _type = comment.getType();
                boolean _equals = Objects.equal((Object)_type, (Object)FAnnotationType.DESCRIPTION);
                if (!_equals) continue;
                String _ReformatComment = this.ReformatComment(comment, prefixForNewLines);
                _builder.append((Object)_ReformatComment, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public String appendJavadocParameter(FTypedElement element, String prefixForNewLines) {
        FTypeRef _type_1;
        boolean _isTypeDef;
        boolean _notEquals;
        String _joynrName = this._namingUtil.joynrName(element);
        String _plus = prefixForNewLines + " @param " + _joynrName;
        String description = _plus + " ";
        FAnnotationBlock _comment = element.getComment();
        boolean bl = _notEquals = !Objects.equal((Object)_comment, null);
        if (_notEquals) {
            FAnnotationBlock _comment_1 = element.getComment();
            EList _elements = _comment_1.getElements();
            for (FAnnotation comment : _elements) {
                FAnnotationType _type = comment.getType();
                boolean _equals = Objects.equal((Object)_type, (Object)FAnnotationType.DESCRIPTION);
                if (!_equals) continue;
                String _description = description;
                String _ReformatComment = this.ReformatComment(comment, prefixForNewLines);
                description = _description + _ReformatComment;
            }
        } else {
            String _description_1 = description;
            description = _description_1 + "description missing in Franca model.";
        }
        if (_isTypeDef = this._javaTypeUtil.isTypeDef(_type_1 = element.getType())) {
            String _description_2 = description;
            FTypeRef _type_2 = element.getType();
            String _joynrName_1 = this._namingUtil.joynrName(_type_2);
            String _plus_1 = "\n" + prefixForNewLines + " (type resolved from modeled Franca typedef " + _joynrName_1;
            String _plus_2 = _plus_1 + " as ";
            FTypeRef _type_3 = element.getType();
            FTypeDef _typeDefType = this._javaTypeUtil.getTypeDefType(_type_3);
            FTypeRef _actualType = _typeDefType.getActualType();
            String _typeName = this._javaTypeUtil.getTypeName(_actualType);
            String _plus_3 = _plus_2 + _typeName;
            String _plus_4 = _plus_3 + ")";
            description = _description_2 + _plus_4;
        }
        return description;
    }

    public String getIncludeOf(FType dataType) {
        String _buildPackagePath = this.buildPackagePath(dataType, ".", true);
        String _plus = _buildPackagePath + ".";
        String _joynrName = this._namingUtil.joynrName(dataType);
        return _plus + _joynrName;
    }

    public boolean hasArrayMembers(FCompoundType datatype) {
        EList _members = this._javaTypeUtil.getMembers(datatype);
        for (FField member : _members) {
            boolean _isArray = this._javaTypeUtil.isArray((FTypedElement)member);
            if (!_isArray) continue;
            return true;
        }
        return false;
    }

    public String getJoynTypePackagePrefix() {
        return this.getJoynrGenerationPrefix();
    }

    public boolean activateJeeExtension() {
        this.jeeExtension = true;
        return true;
    }

    public boolean jeeExtension() {
        return this.jeeExtension;
    }

    public String getProviderClassName(FInterface francaIntf) {
        String _joynrName = this._namingUtil.joynrName(francaIntf);
        return _joynrName + "Provider";
    }

    public String getProxyClassName(FInterface francaIntf) {
        String _joynrName = this._namingUtil.joynrName(francaIntf);
        return _joynrName + "Proxy";
    }
}

