/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.GraphiteUDP;
import com.codahale.metrics.graphite.PickledGraphite;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.dropwizard.DropwizardClock;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.lang.Nullable;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteHierarchicalNameMapper;
import io.micrometer.graphite.GraphiteNamingConvention;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class GraphiteMeterRegistry
extends DropwizardMeterRegistry {
    private final GraphiteConfig config;
    private final GraphiteReporter reporter;

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock) {
        this(config, clock, new GraphiteHierarchicalNameMapper(config.tagsAsPrefix()));
    }

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, HierarchicalNameMapper nameMapper) {
        this(config, clock, nameMapper, new MetricRegistry());
    }

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry) {
        this(config, clock, nameMapper, metricRegistry, GraphiteMeterRegistry.defaultGraphiteReporter(config, clock, metricRegistry));
    }

    public GraphiteMeterRegistry(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry, GraphiteReporter reporter) {
        super((DropwizardConfig)config, metricRegistry, nameMapper, clock);
        this.config = config;
        this.config().namingConvention((NamingConvention)new GraphiteNamingConvention());
        this.reporter = reporter;
        this.start();
    }

    private static GraphiteReporter defaultGraphiteReporter(GraphiteConfig config, io.micrometer.core.instrument.Clock clock, MetricRegistry metricRegistry) {
        return GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).withClock((Clock)new DropwizardClock(clock)).convertRatesTo(config.rateUnits()).convertDurationsTo(config.durationUnits()).build(GraphiteMeterRegistry.getGraphiteSender(config));
    }

    private static GraphiteSender getGraphiteSender(GraphiteConfig config) {
        InetSocketAddress address = new InetSocketAddress(config.host(), config.port());
        switch (config.protocol()) {
            case PLAINTEXT: {
                return new Graphite(address);
            }
            case UDP: {
                return new GraphiteUDP(address);
            }
        }
        return new PickledGraphite(address);
    }

    public void stop() {
        if (this.config.enabled()) {
            this.reporter.stop();
        }
    }

    public void start() {
        if (this.config.enabled()) {
            this.reporter.start(this.config.step().getSeconds(), TimeUnit.SECONDS);
        }
    }

    public void close() {
        if (this.config.enabled()) {
            this.reporter.report();
        }
        this.stop();
        if (this.config.enabled()) {
            this.reporter.close();
        }
        super.close();
    }

    @Nullable
    protected Double nullGaugeValue() {
        return null;
    }
}

