/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class OpenApiControllerVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<Controller, HttpMethodMapping> {
    public void visitClass(ClassElement element, VisitorContext context) {
        this.processSecuritySchemes(element, context);
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        Optional httpMethodOpt = element.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        if (element.isAnnotationPresent(Hidden.class)) {
            return;
        }
        httpMethodOpt.ifPresent(httpMethodClass -> {
            List bodyParameters;
            boolean hasExistingParameters;
            HttpMethod httpMethod = null;
            try {
                httpMethod = HttpMethod.valueOf((String)httpMethodClass.getSimpleName().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (httpMethod == null) {
                return;
            }
            UriMatchTemplate matchTemplate = UriMatchTemplate.of((String)element.getValue(Controller.class, String.class).orElse("/"));
            matchTemplate = matchTemplate.nest((CharSequence)element.getValue(HttpMethodMapping.class, String.class).orElse("/"));
            PathItem pathItem = this.resolvePathItem(context, matchTemplate);
            OpenAPI openAPI = this.resolveOpenAPI(context);
            Optional operationAnnotation = element.findAnnotation(io.swagger.v3.oas.annotations.Operation.class);
            Operation swaggerOperation = operationAnnotation.flatMap(o -> {
                JsonNode jsonNode = this.toJson(o.getValues(), context);
                try {
                    return Optional.of(this.jsonMapper.treeToValue((TreeNode)jsonNode, Operation.class));
                }
                catch (Exception e) {
                    context.warn("Error reading Swagger Operation for element [" + element + "]: " + e.getMessage(), (Element)element);
                    return Optional.empty();
                }
            }).orElse(new Operation());
            this.readTags(element, swaggerOperation);
            this.readSecurityRequirements(element, context, swaggerOperation);
            this.readApiResponses(element, context, swaggerOperation);
            this.readServers(element, context, swaggerOperation);
            this.readCallbacks(element, context, swaggerOperation);
            JavadocDescription javadocDescription = element.getDocumentation().map(s -> new JavadocParser().parse((String)s)).orElse(null);
            if (javadocDescription != null && StringUtils.isEmpty((CharSequence)swaggerOperation.getDescription())) {
                swaggerOperation.setDescription(javadocDescription.getMethodDescription());
            }
            this.setOperationOnPathItem(pathItem, swaggerOperation, httpMethod);
            if (element.isAnnotationPresent(Deprecated.class)) {
                swaggerOperation.setDeprecated(Boolean.valueOf(true));
            }
            if (StringUtils.isEmpty((CharSequence)swaggerOperation.getOperationId())) {
                swaggerOperation.setOperationId(element.getName());
            }
            boolean permitsRequestBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> swaggerParameters = swaggerOperation.getParameters();
            List pv = matchTemplate.getVariables();
            LinkedHashMap<String, UriMatchVariable> pathVariables = new LinkedHashMap<String, UriMatchVariable>(pv.size());
            for (UriMatchVariable variable : pv) {
                pathVariables.put(variable.getName(), variable);
            }
            String consumesMediaType = element.getValue(Consumes.class, String.class).orElse("application/json");
            ApiResponses responses = swaggerOperation.getResponses();
            if (responses == null) {
                ClassElement returnType;
                responses = new ApiResponses();
                swaggerOperation.setResponses(responses);
                ApiResponse okResponse = new ApiResponse();
                if (javadocDescription != null) {
                    String returnDescription = javadocDescription.getReturnDescription();
                    okResponse.setDescription(returnDescription);
                }
                if ((returnType = element.getReturnType()) != null && this.isResponseType(returnType)) {
                    returnType = returnType.getFirstTypeArgument().orElse(returnType);
                }
                if (returnType != null) {
                    String mediaType = element.getValue(Produces.class, String.class).orElse("application/json");
                    Content content = this.buildContent((Element)element, returnType, mediaType, openAPI, context);
                    okResponse.setContent(content);
                }
                responses.put((Object)"default", (Object)okResponse);
            }
            if (!(hasExistingParameters = CollectionUtils.isNotEmpty((Collection)swaggerParameters))) {
                swaggerParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
                swaggerOperation.setParameters(swaggerParameters);
            }
            for (ClassElement parameter : element.getParameters()) {
                AnnotationValue paramAnn;
                CharSequence desc;
                ClassElement parameterType = parameter.getType();
                String parameterName = parameter.getName();
                if (parameterType == null || this.isIgnoredParameterType(parameterType)) continue;
                if (parameter.isAnnotationPresent(Body.class)) {
                    if (!permitsRequestBody || swaggerOperation.getRequestBody() != null) continue;
                    RequestBody requestBody = new RequestBody();
                    if (javadocDescription != null && (desc = javadocDescription.getParameters().get(parameterName)) != null) {
                        requestBody.setDescription(desc.toString());
                    }
                    requestBody.setRequired(Boolean.valueOf(!parameter.isAnnotationPresent(Nullable.class) && !parameterType.isAssignable(Optional.class)));
                    Content content = this.buildContent((Element)parameter, parameterType, consumesMediaType, openAPI, context);
                    requestBody.setContent(content);
                    swaggerOperation.setRequestBody(requestBody);
                    continue;
                }
                if (hasExistingParameters) continue;
                io.swagger.v3.oas.models.parameters.Parameter newParameter = null;
                if (!parameter.hasStereotype(Bindable.class) && pathVariables.containsKey(parameterName)) {
                    UriMatchVariable var = (UriMatchVariable)pathVariables.get(parameterName);
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(var.isQuery() ? ParameterIn.QUERY.toString() : ParameterIn.PATH.toString());
                    boolean exploded = var.isExploded();
                    if (exploded) {
                        newParameter.setExplode(Boolean.valueOf(exploded));
                    }
                } else if (parameter.isAnnotationPresent(Header.class)) {
                    String headerName = parameter.getValue(Header.class, "name", String.class).orElseGet(() -> NameUtils.hyphenate((String)parameterName));
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.HEADER.toString());
                    newParameter.setName(headerName);
                } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                    String cookieName = parameter.getValue(CookieValue.class, String.class).orElse(parameterName);
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.COOKIE.toString());
                    newParameter.setName(cookieName);
                } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                    String queryVar = parameter.getValue(QueryValue.class, String.class).orElse(parameterName);
                    newParameter = new io.swagger.v3.oas.models.parameters.Parameter();
                    newParameter.setIn(ParameterIn.QUERY.toString());
                    newParameter.setName(queryVar);
                }
                if (parameter.isAnnotationPresent(Parameter.class) && (paramAnn = (AnnotationValue)parameter.findAnnotation(Parameter.class).orElse(null)) != null) {
                    if (((Boolean)paramAnn.get((CharSequence)"hidden", Boolean.class, (Object)false)).booleanValue()) continue;
                    Map<CharSequence, Object> paramValues = this.toValueMap(paramAnn.getValues(), context);
                    this.normalizeEnumValues(paramValues, Collections.singletonMap("in", ParameterIn.class));
                    if (parameter.isAnnotationPresent(Header.class)) {
                        paramValues.put("in", ParameterIn.HEADER.toString());
                    } else if (parameter.isAnnotationPresent(CookieValue.class)) {
                        paramValues.put("in", ParameterIn.COOKIE.toString());
                    } else if (parameter.isAnnotationPresent(QueryValue.class)) {
                        paramValues.put("in", ParameterIn.QUERY.toString());
                    }
                    JsonNode jsonNode = this.jsonMapper.valueToTree(paramValues);
                    if (newParameter == null) {
                        try {
                            newParameter = (io.swagger.v3.oas.models.parameters.Parameter)this.jsonMapper.treeToValue((TreeNode)jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class);
                        }
                        catch (Exception e) {
                            context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                        }
                    } else {
                        try {
                            io.swagger.v3.oas.models.parameters.Parameter v = (io.swagger.v3.oas.models.parameters.Parameter)this.jsonMapper.treeToValue((TreeNode)jsonNode, io.swagger.v3.oas.models.parameters.Parameter.class);
                            if (v != null) {
                                BeanMap beanMap = BeanMap.of((Object)v);
                                BeanMap target = BeanMap.of((Object)newParameter);
                                for (CharSequence name : paramValues.keySet()) {
                                    Object o2 = beanMap.get((Object)name.toString());
                                    target.put((Object)name.toString(), o2);
                                }
                            } else {
                                BeanMap target = BeanMap.of((Object)newParameter);
                                for (CharSequence name : paramValues.keySet()) {
                                    Object o3 = paramValues.get(name.toString());
                                    try {
                                        target.put((Object)name.toString(), o3);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        catch (IOException e) {
                            context.warn("Error reading Swagger Parameter for element [" + parameter + "]: " + e.getMessage(), (Element)parameter);
                        }
                    }
                    if (newParameter != null) {
                        AnnotationValue schemaAnn;
                        Schema parameterSchema = newParameter.getSchema();
                        if (paramAnn.contains("schema") && parameterSchema != null && (schemaAnn = (AnnotationValue)paramAnn.get((CharSequence)"schema", AnnotationValue.class).orElse(null)) != null) {
                            this.bindSchemaAnnotationValue(context, (Element)parameter, parameterSchema, (AnnotationValue<io.swagger.v3.oas.annotations.media.Schema>)schemaAnn);
                        }
                    }
                }
                if (newParameter == null) continue;
                if (StringUtils.isEmpty((CharSequence)newParameter.getName())) {
                    newParameter.setName(parameterName);
                }
                if (newParameter.getRequired() == null) {
                    newParameter.setRequired(Boolean.valueOf(!parameter.isAnnotationPresent(Nullable.class)));
                }
                if (javadocDescription != null && StringUtils.isEmpty((CharSequence)newParameter.getDescription()) && (desc = javadocDescription.getParameters().get(parameterName)) != null) {
                    newParameter.setDescription(desc.toString());
                }
                swaggerParameters.add(newParameter);
                Schema schema = newParameter.getSchema();
                if (schema == null) {
                    schema = this.resolveSchema(openAPI, (Element)parameter, parameterType, context, consumesMediaType);
                }
                if (schema == null) continue;
                this.bindSchemaForElement(context, (Element)parameter, parameter.getType(), schema);
                newParameter.setSchema(schema);
            }
            if (HttpMethod.requiresRequestBody((HttpMethod)httpMethod) && swaggerOperation.getRequestBody() == null && !(bodyParameters = Arrays.stream(element.getParameters()).filter(p -> !pathVariables.containsKey(p.getName()) && !p.isAnnotationPresent(Bindable.class)).collect(Collectors.toList())).isEmpty()) {
                RequestBody requestBody = new RequestBody();
                Content content = new Content();
                MediaType mt = new MediaType();
                ObjectSchema schema = new ObjectSchema();
                for (ParameterElement parameter : bodyParameters) {
                    CharSequence doc;
                    Schema propertySchema;
                    if (parameter.isAnnotationPresent(JsonIgnore.class) || parameter.isAnnotationPresent(Hidden.class) || parameter.getValue(Parameter.class, "hidden", Boolean.class).orElse(false).booleanValue() || this.isIgnoredParameterType(parameter.getType()) || (propertySchema = this.resolveSchema(openAPI, (Element)parameter, parameter.getType(), context, consumesMediaType)) == null) continue;
                    this.processSchemaProperty(context, (Element)parameter, parameter.getType(), (Schema)schema, propertySchema);
                    propertySchema.setNullable(Boolean.valueOf(parameter.isAnnotationPresent(Nullable.class)));
                    if (javadocDescription == null || !StringUtils.isEmpty((CharSequence)propertySchema.getDescription()) || (doc = javadocDescription.getParameters().get(parameter.getName())) == null) continue;
                    propertySchema.setDescription(doc.toString());
                }
                mt.setSchema((Schema)schema);
                content.addMediaType(consumesMediaType, mt);
                requestBody.setContent(content);
                requestBody.setRequired(Boolean.valueOf(true));
                swaggerOperation.setRequestBody(requestBody);
            }
        });
    }

    private boolean isIgnoredParameterType(ClassElement parameterType) {
        return parameterType == null || parameterType.isAssignable(Principal.class) || parameterType.isAssignable("io.micronaut.security.authentication.Authentication");
    }

    private boolean isResponseType(ClassElement returnType) {
        return returnType.isAssignable(HttpResponse.class) || returnType.isAssignable("org.springframework.http.HttpEntity");
    }

    private void setOperationOnPathItem(PathItem pathItem, Operation swaggerOperation, HttpMethod httpMethod) {
        switch (httpMethod) {
            case GET: {
                pathItem.get(swaggerOperation);
                break;
            }
            case POST: {
                pathItem.post(swaggerOperation);
                break;
            }
            case PUT: {
                pathItem.put(swaggerOperation);
                break;
            }
            case PATCH: {
                pathItem.patch(swaggerOperation);
                break;
            }
            case DELETE: {
                pathItem.delete(swaggerOperation);
                break;
            }
            case HEAD: {
                pathItem.head(swaggerOperation);
                break;
            }
            case OPTIONS: {
                pathItem.options(swaggerOperation);
                break;
            }
            case TRACE: {
                pathItem.trace(swaggerOperation);
                break;
            }
        }
    }

    private void readApiResponses(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List responseAnnotations = element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        if (CollectionUtils.isNotEmpty((Collection)responseAnnotations)) {
            ApiResponses apiResponses = new ApiResponses();
            for (AnnotationValue r : responseAnnotations) {
                JsonNode jn = this.toJson(r.getValues(), context);
                try {
                    Optional<Object> newResponse = Optional.of(this.jsonMapper.treeToValue((TreeNode)jn, ApiResponse.class));
                    newResponse.ifPresent(apiResponse -> {
                        String name = r.get((CharSequence)"responseCode", String.class).orElse("default");
                        apiResponses.put((Object)name, apiResponse);
                    });
                }
                catch (Exception e) {
                    context.warn("Error reading Swagger ApiResponses for element [" + element + "]: " + e.getMessage(), (Element)element);
                }
            }
            swaggerOperation.setResponses(apiResponses);
        }
    }

    private void readSecurityRequirements(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List securityAnnotations = element.getAnnotationValuesByType(io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
        if (CollectionUtils.isNotEmpty((Collection)securityAnnotations)) {
            for (AnnotationValue r : securityAnnotations) {
                JsonNode jn = this.toJson(r.getValues(), context);
                try {
                    Optional<Object> newRequirement = Optional.of(this.jsonMapper.treeToValue((TreeNode)jn, SecurityRequirement.class));
                    newRequirement.ifPresent(arg_0 -> ((Operation)swaggerOperation).addSecurityItem(arg_0));
                }
                catch (Exception e) {
                    context.warn("Error reading Swagger SecurityRequirement for element [" + element + "]: " + e.getMessage(), (Element)element);
                }
            }
        }
    }

    private void readServers(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List serverAnnotations = element.getAnnotationValuesByType(Server.class);
        if (CollectionUtils.isNotEmpty((Collection)serverAnnotations)) {
            for (AnnotationValue r : serverAnnotations) {
                JsonNode jn = this.toJson(r.getValues(), context);
                try {
                    Optional<Object> newRequirement = Optional.of(this.jsonMapper.treeToValue((TreeNode)jn, io.swagger.v3.oas.models.servers.Server.class));
                    newRequirement.ifPresent(arg_0 -> ((Operation)swaggerOperation).addServersItem(arg_0));
                }
                catch (Exception e) {
                    context.warn("Error reading Swagger Server for element [" + element + "]: " + e.getMessage(), (Element)element);
                }
            }
        }
    }

    private void readCallbacks(MethodElement element, VisitorContext context, Operation swaggerOperation) {
        List callbackAnnotations = element.getAnnotationValuesByType(Callback.class);
        if (CollectionUtils.isNotEmpty((Collection)callbackAnnotations)) {
            for (AnnotationValue callbackAnn : callbackAnnotations) {
                Optional n = callbackAnn.get((CharSequence)"name", String.class);
                n.ifPresent(callbackName -> {
                    Optional expr = callbackAnn.get((CharSequence)"callbackUrlExpression", String.class);
                    if (expr.isPresent()) {
                        String callbackUrl = (String)expr.get();
                        List operations = callbackAnn.getAnnotations("operation", io.swagger.v3.oas.annotations.Operation.class);
                        if (CollectionUtils.isEmpty((Collection)operations)) {
                            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
                            io.swagger.v3.oas.models.callbacks.Callback c = new io.swagger.v3.oas.models.callbacks.Callback();
                            c.addPathItem(callbackUrl, new PathItem());
                            callbacks.put((String)callbackName, c);
                        } else {
                            PathItem pathItem = new PathItem();
                            for (AnnotationValue operation : operations) {
                                Optional operationMethod = operation.get((CharSequence)"method", HttpMethod.class);
                                operationMethod.ifPresent(httpMethod -> {
                                    JsonNode jsonNode = this.toJson(operation.getValues(), context);
                                    try {
                                        Optional<Object> op = Optional.of(this.jsonMapper.treeToValue((TreeNode)jsonNode, Operation.class));
                                        op.ifPresent(operation1 -> this.setOperationOnPathItem(pathItem, (Operation)operation1, (HttpMethod)httpMethod));
                                    }
                                    catch (Exception e) {
                                        context.warn("Error reading Swagger Operation for element [" + element + "]: " + e.getMessage(), (Element)element);
                                    }
                                });
                            }
                            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
                            io.swagger.v3.oas.models.callbacks.Callback c = new io.swagger.v3.oas.models.callbacks.Callback();
                            c.addPathItem(callbackUrl, pathItem);
                            callbacks.put((String)callbackName, c);
                        }
                    } else {
                        Components components = this.resolveComponents(this.resolveOpenAPI(context));
                        Map callbackComponents = components.getCallbacks();
                        if (callbackComponents != null && callbackComponents.containsKey(callbackName)) {
                            Map<String, io.swagger.v3.oas.models.callbacks.Callback> callbacks = this.initCallbacks(swaggerOperation);
                            io.swagger.v3.oas.models.callbacks.Callback callbackRef = new io.swagger.v3.oas.models.callbacks.Callback();
                            callbackRef.set$ref("#/components/callbacks/" + callbackName);
                            callbacks.put((String)callbackName, callbackRef);
                        }
                    }
                });
            }
        }
    }

    private Map<String, io.swagger.v3.oas.models.callbacks.Callback> initCallbacks(Operation swaggerOperation) {
        LinkedHashMap callbacks = swaggerOperation.getCallbacks();
        if (callbacks == null) {
            callbacks = new LinkedHashMap();
            swaggerOperation.setCallbacks(callbacks);
        }
        return callbacks;
    }

    private void readTags(MethodElement element, Operation swaggerOperation) {
        List tagAnnotations = element.getAnnotationValuesByType(Tag.class);
        if (CollectionUtils.isNotEmpty((Collection)tagAnnotations)) {
            for (AnnotationValue r : tagAnnotations) {
                r.get((CharSequence)"name", String.class).ifPresent(arg_0 -> ((Operation)swaggerOperation).addTagsItem(arg_0));
            }
        }
    }

    private Content buildContent(Element definingElement, ClassElement type, String mediaType, OpenAPI openAPI, VisitorContext context) {
        Content content = new Content();
        MediaType mt = new MediaType();
        mt.setSchema(this.resolveSchema(openAPI, definingElement, type, context, mediaType));
        content.addMediaType(mediaType, mt);
        return content;
    }
}

