/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.openapi.visitor.AbstractOpenApiVisitor;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class OpenApiApplicationVisitor
extends AbstractOpenApiVisitor
implements TypeElementVisitor<OpenAPIDefinition, Object> {
    public static final String MICRONAUT_OPENAPI_TARGET_FILE = "micronaut.openapi.target.file";
    private ClassElement classElement;

    public void visitClass(ClassElement element, VisitorContext context) {
        context.info("Generating OpenAPI Documentation");
        Optional attr = context.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
        OpenAPI openAPI = this.readOpenAPI(element, context);
        if (attr.isPresent()) {
            OpenAPI existing = (OpenAPI)attr.get();
            existing.setInfo(openAPI.getInfo());
            existing.setTags(openAPI.getTags());
            existing.setServers(openAPI.getServers());
            existing.setSecurity(openAPI.getSecurity());
            existing.setExternalDocs(openAPI.getExternalDocs());
            existing.setExtensions(openAPI.getExtensions());
        } else {
            context.put((CharSequence)"io.micronaut.OPENAPI", (Object)openAPI);
        }
        List<io.swagger.v3.oas.models.tags.Tag> tagList = this.processOpenApiAnnotation(element, context, Tag.class, io.swagger.v3.oas.models.tags.Tag.class, openAPI.getTags());
        openAPI.setTags(tagList);
        List<SecurityRequirement> securityRequirements = this.processOpenApiAnnotation(element, context, io.swagger.v3.oas.annotations.security.SecurityRequirement.class, SecurityRequirement.class, openAPI.getSecurity());
        openAPI.setSecurity(securityRequirements);
        List<Server> servers = this.processOpenApiAnnotation(element, context, io.swagger.v3.oas.annotations.servers.Server.class, Server.class, openAPI.getServers());
        openAPI.setServers(servers);
        this.processSecuritySchemes(element, context);
        if (Boolean.getBoolean("io.micronaut.OPENAPI_TEST")) {
            testReference = openAPI;
        }
        this.classElement = element;
    }

    private <T, A extends Annotation> List<T> processOpenApiAnnotation(ClassElement element, VisitorContext context, Class<A> annotationType, Class<T> modelType, List<T> tagList) {
        List annotations = element.getAnnotationValuesByType(annotationType);
        if (CollectionUtils.isNotEmpty((Collection)annotations)) {
            if (CollectionUtils.isEmpty(tagList)) {
                tagList = new ArrayList<T>();
            }
            for (AnnotationValue tag : annotations) {
                JsonNode jsonNode = this.toJson(tag.getValues(), context);
                try {
                    Object t = this.jsonMapper.treeToValue((TreeNode)jsonNode, modelType);
                    if (t == null) continue;
                    tagList.add(t);
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading OpenAPI" + annotationType + " annotation", (Element)element);
                }
            }
        }
        return tagList;
    }

    private OpenAPI readOpenAPI(ClassElement element, VisitorContext context) {
        return element.findAnnotation(OpenAPIDefinition.class).flatMap(o -> {
            JsonNode jsonNode = this.toJson(o.getValues(), context);
            try {
                return Optional.of(this.jsonMapper.treeToValue((TreeNode)jsonNode, OpenAPI.class));
            }
            catch (JsonProcessingException e) {
                context.warn("Error reading Swagger OpenAPI for element [" + element + "]: " + e.getMessage(), (Element)element);
                return Optional.empty();
            }
        }).orElse(new OpenAPI());
    }

    public void finish(VisitorContext visitorContext) {
        if (this.classElement != null) {
            Optional attr = visitorContext.get((CharSequence)"io.micronaut.OPENAPI", OpenAPI.class);
            attr.ifPresent(openAPI -> {
                String property = System.getProperty(MICRONAUT_OPENAPI_TARGET_FILE);
                if (StringUtils.isNotEmpty((CharSequence)property)) {
                    File f = new File(property);
                    visitorContext.info("Writing OpenAPI YAML to destination: " + f);
                    try {
                        f.getParentFile().mkdirs();
                        this.yamlMapper.writeValue(f, openAPI);
                    }
                    catch (Exception e) {
                        visitorContext.warn("Unable to generate swagger.yml: " + e.getMessage(), (Element)this.classElement);
                    }
                } else {
                    Optional generatedFile;
                    String fileName = "swagger.yml";
                    Info info = openAPI.getInfo();
                    if (info != null) {
                        String title = Optional.ofNullable(info.getTitle()).orElse("application");
                        title = title.toLowerCase().replace(' ', '-');
                        String version = info.getVersion();
                        if (version != null) {
                            fileName = title + "-" + version + ".yml";
                        }
                    }
                    if ((generatedFile = visitorContext.visitMetaInfFile("swagger/" + fileName)).isPresent()) {
                        GeneratedFile f = (GeneratedFile)generatedFile.get();
                        try {
                            visitorContext.info("Writing OpenAPI YAML to destination: " + f.toURI());
                            Writer writer = f.openWriter();
                            this.yamlMapper.writeValue(writer, openAPI);
                        }
                        catch (Exception e) {
                            visitorContext.warn("Unable to generate swagger.yml: " + e.getMessage(), (Element)this.classElement);
                        }
                    }
                }
            });
        }
    }
}

