/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.jackson.JsonContentProcessor;
import java.util.Optional;
import javax.inject.Singleton;

@Consumes(value={"application/x-json-stream", "application/json"})
@Singleton
@Internal
public class JsonHttpContentSubscriberFactory
implements HttpContentSubscriberFactory {
    private final HttpServerConfiguration httpServerConfiguration;
    private final Optional<JsonFactory> jsonFactory;

    public JsonHttpContentSubscriberFactory(HttpServerConfiguration httpServerConfiguration, Optional<JsonFactory> jsonFactory) {
        this.httpServerConfiguration = httpServerConfiguration;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public HttpContentProcessor build(NettyHttpRequest request) {
        return new JsonContentProcessor(request, this.httpServerConfiguration, this.jsonFactory);
    }
}

