/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.stream;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseType;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyStreamedCustomizableResponseType
extends NettyCustomizableResponseType {
    public static final Logger LOG = LoggerFactory.getLogger(NettyStreamedCustomizableResponseType.class);

    public InputStream getInputStream();

    @Override
    default public void write(HttpRequest<?> request, MutableHttpResponse<?> response, ChannelHandlerContext context) {
        if (response instanceof NettyMutableHttpResponse) {
            HttpHeaders nativeHeaders;
            String streamId;
            boolean isHttp2;
            NettyMutableHttpResponse nettyResponse = (NettyMutableHttpResponse)response;
            DefaultHttpResponse finalResponse = new DefaultHttpResponse(nettyResponse.getNettyHttpVersion(), nettyResponse.getNettyHttpStatus(), nettyResponse.getNettyHeaders());
            HttpVersion httpVersion = request.getHttpVersion();
            boolean bl = isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
            if (isHttp2 && request instanceof NettyHttpRequest && (streamId = (nativeHeaders = ((NettyHttpRequest)request).getNativeRequest().headers()).get((CharSequence)AbstractNettyHttpRequest.STREAM_ID)) != null) {
                finalResponse.headers().set((CharSequence)AbstractNettyHttpRequest.STREAM_ID, (Object)streamId);
            }
            InputStream inputStream = this.getInputStream();
            context.write((Object)finalResponse, context.voidPromise());
            if (inputStream != null) {
                ChannelFutureListener closeListener = future -> {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn("An error occurred closing an input stream", (Throwable)e);
                    }
                };
                HttpChunkedInput chunkedInput = new HttpChunkedInput((ChunkedInput)new ChunkedStream(inputStream));
                context.writeAndFlush((Object)chunkedInput).addListener((GenericFutureListener)closeListener);
            } else {
                context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            }
        } else {
            throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
        }
    }

    default public void process(MutableHttpResponse<?> response) {
        response.header((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
    }
}

