/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.RequestLifecycle;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.handler.PipeliningServerHandler;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.http.server.types.files.StreamedFile;
import io.micronaut.http.server.types.files.SystemFile;
import io.micronaut.web.router.RouteMatch;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class NettyRequestLifecycle
extends RequestLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(NettyRequestLifecycle.class);
    private final RoutingInBoundHandler rib;
    private final PipeliningServerHandler.OutboundAccess outboundAccess;
    private final NettyHttpRequest<?> nettyRequest;

    NettyRequestLifecycle(RoutingInBoundHandler rib, PipeliningServerHandler.OutboundAccess outboundAccess, NettyHttpRequest<?> request) {
        super(rib.routeExecutor, request);
        this.rib = rib;
        this.outboundAccess = outboundAccess;
        this.nettyRequest = request;
        this.multipartEnabled(rib.multipartEnabled);
    }

    void handleNormal() {
        if (LOG.isDebugEnabled()) {
            HttpMethod httpMethod = this.request().getMethod();
            LOG.debug("Request {} {}", (Object)httpMethod, (Object)this.request().getUri());
        }
        try {
            ExecutionFlow result;
            DecoderResult decoderResult = this.nettyRequest.getNativeRequest().decoderResult();
            if (decoderResult.isFailure()) {
                Throwable cause = decoderResult.cause();
                HttpStatus status = cause instanceof TooLongFrameException ? HttpStatus.REQUEST_ENTITY_TOO_LARGE : HttpStatus.BAD_REQUEST;
                result = this.onStatusError(HttpResponse.status((HttpStatus)status), status.getReason());
            } else {
                result = this.normalFlow();
            }
            result.onComplete((response, throwable) -> this.rib.writeResponse(this.outboundAccess, this.nettyRequest, (MutableHttpResponse<?>)response, (Throwable)throwable));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Nullable
    protected FileCustomizableResponseType findFile() {
        Optional optionalUrl = this.rib.staticResourceResolver.resolve(this.request().getUri().getPath());
        if (optionalUrl.isPresent()) {
            try {
                File file;
                URL url = (URL)optionalUrl.get();
                if (url.getProtocol().equals("file") && (file = Paths.get(url.toURI()).toFile()).exists() && !file.isDirectory() && file.canRead()) {
                    return new SystemFile(file);
                }
                return new StreamedFile(url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    protected ExecutionFlow<RouteMatch<?>> fulfillArguments(RouteMatch<?> routeMatch) {
        DecoderResult decoderResult = this.nettyRequest.getNativeRequest().decoderResult();
        if (decoderResult.isFailure()) {
            return ExecutionFlow.error((Throwable)decoderResult.cause());
        }
        return super.fulfillArguments(routeMatch).flatMap(this::waitForBody);
    }

    private ExecutionFlow<RouteMatch<?>> waitForBody(RouteMatch<?> routeMatch) {
        if (this.nettyRequest.hasFormRouteCompleter()) {
            FormDataHttpContentProcessor processor = new FormDataHttpContentProcessor(this.nettyRequest, this.rib.serverConfiguration);
            ByteBody rootBody = this.nettyRequest.byteBody();
            FormRouteCompleter formRouteCompleter = this.nettyRequest.formRouteCompleter();
            try {
                rootBody.processMulti(processor).handleForm(formRouteCompleter);
                this.nettyRequest.addRouteWaitsFor((ExecutionFlow<?>)formRouteCompleter.getExecute());
            }
            catch (Throwable e) {
                return ExecutionFlow.error((Throwable)e);
            }
        }
        return this.nettyRequest.getRouteWaitsFor().map(v -> routeMatch);
    }

    void handleException(Throwable cause) {
        this.onError(cause).onComplete((response, throwable) -> this.rib.writeResponse(this.outboundAccess, this.nettyRequest, (MutableHttpResponse<?>)response, (Throwable)throwable));
    }
}

