/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Optional;

@Prototype
@Internal
public class NettyConverters
implements TypeConverterRegistrar {
    private final ConversionService conversionService;
    private final BeanProvider<MediaTypeCodecRegistry> decoderRegistryProvider;
    private final BeanProvider<ChannelOptionFactory> channelOptionFactory;

    public NettyConverters(ConversionService conversionService, BeanProvider<MediaTypeCodecRegistry> decoderRegistryProvider, BeanProvider<ChannelOptionFactory> channelOptionFactory) {
        this.conversionService = conversionService;
        this.decoderRegistryProvider = decoderRegistryProvider;
        this.channelOptionFactory = channelOptionFactory;
    }

    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(CharSequence.class, ChannelOption.class, (object, targetType, context) -> {
            String str = object.toString();
            String name = NameUtils.underscoreSeparate((String)str).toUpperCase(Locale.ENGLISH);
            return Optional.of(((ChannelOptionFactory)this.channelOptionFactory.get()).channelOption(name));
        });
        conversionService.addConverter(ByteBuf.class, Object.class, this.byteBufToObjectConverter());
        conversionService.addConverter(FileUpload.class, Object.class, this.fileUploadToObjectConverter());
        conversionService.addConverter(NettyPartData.class, Object.class, this.nettyPartDataToObjectConverter());
        conversionService.addConverter(Attribute.class, Object.class, this.nettyAttributeToObjectConverter());
        conversionService.addConverter(String.class, ChannelOption.class, s -> ((ChannelOptionFactory)this.channelOptionFactory.get()).channelOption(NameUtils.environmentName((String)s)));
    }

    private TypeConverter<Attribute, Object> nettyAttributeToObjectConverter() {
        return (object, targetType, context) -> {
            try {
                String value = object.getValue();
                if (targetType.isInstance(value)) {
                    return Optional.of(value);
                }
                return this.conversionService.convert((Object)value, targetType, context);
            }
            catch (IOException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        };
    }

    private TypeConverter<NettyPartData, Object> nettyPartDataToObjectConverter() {
        return (object, targetType, context) -> {
            Optional optional;
            if (targetType.isAssignableFrom(ByteBuffer.class)) {
                return Optional.of(object.getByteBuffer());
            }
            if (targetType.isAssignableFrom(InputStream.class)) {
                return Optional.of(object.getInputStream());
            }
            ByteBuf byteBuf = object.getByteBuf();
            try {
                optional = this.conversionService.convert((Object)byteBuf, targetType, context);
            }
            catch (Throwable throwable) {
                try {
                    byteBuf.release();
                    throw throwable;
                }
                catch (IOException e) {
                    context.reject((Exception)e);
                    return Optional.empty();
                }
            }
            byteBuf.release();
            return optional;
        };
    }

    protected TypeConverter<FileUpload, Object> fileUploadToObjectConverter() {
        return (object, targetType, context) -> {
            try {
                if (!object.isCompleted()) {
                    return Optional.empty();
                }
                String contentType = object.getContentType();
                ByteBuf byteBuf = object.getByteBuf();
                if (StringUtils.isNotEmpty((CharSequence)contentType)) {
                    MediaType mediaType = MediaType.of((String)contentType);
                    Optional registered = ((MediaTypeCodecRegistry)this.decoderRegistryProvider.get()).findCodec(mediaType);
                    if (registered.isPresent()) {
                        MediaTypeCodec decoder = (MediaTypeCodec)registered.get();
                        Object val = decoder.decode(targetType, (InputStream)new ByteBufInputStream(byteBuf));
                        return Optional.of(val);
                    }
                    return this.conversionService.convert((Object)byteBuf, targetType, context);
                }
                return this.conversionService.convert((Object)byteBuf, targetType, context);
            }
            catch (Exception e) {
                context.reject(e);
                return Optional.empty();
            }
        };
    }

    protected TypeConverter<ByteBuf, Object> byteBufToObjectConverter() {
        return (object, targetType, context) -> this.conversionService.convert((Object)object.toString(context.getCharset()), targetType, context);
    }

    public static <T> Optional<T> refCountAwareConvert(ConversionService service, ReferenceCounted input, ArgumentConversionContext<T> context) {
        Optional converted = service.convert((Object)input, context);
        NettyConverters.postProcess(input, converted);
        return converted;
    }

    public static <T> Optional<T> refCountAwareConvert(ConversionService service, ReferenceCounted input, Class<T> targetType, ConversionContext context) {
        Optional converted = service.convert((Object)input, targetType, context);
        NettyConverters.postProcess(input, converted);
        return converted;
    }

    private static <T> void postProcess(ReferenceCounted input, Optional<T> converted) {
        if (converted.isPresent()) {
            boolean targetRefCounted;
            input.touch();
            T item = converted.get();
            boolean bl = targetRefCounted = item instanceof ReferenceCounted || item instanceof io.micronaut.core.io.buffer.ReferenceCounted;
            if (!targetRefCounted) {
                input.release();
            }
        } else {
            input.release();
        }
    }
}

