/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.exceptions.MessageBodyException;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.micronaut.http.server.netty.body.AbstractFileBodyWriter;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.http.server.types.files.SystemFile;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponse;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

@Singleton
@Internal
public final class SystemFileBodyWriter
extends AbstractFileBodyWriter
implements NettyBodyWriter<SystemFile> {
    private static final String UNIT_BYTES = "bytes";
    private final ExecutorService ioExecutor;

    public SystemFileBodyWriter(NettyHttpServerConfiguration.FileTypeHandlerConfiguration configuration, @Named(value="blocking") ExecutorService ioExecutor) {
        super(configuration);
        this.ioExecutor = ioExecutor;
    }

    public void writeTo(HttpRequest<?> request, MutableHttpResponse<SystemFile> outgoingResponse, Argument<SystemFile> type, MediaType mediaType, SystemFile object, NettyWriteContext nettyContext) throws CodecException {
        this.writeTo(request, outgoingResponse, object, nettyContext);
    }

    public void writeTo(Argument<SystemFile> type, MediaType mediaType, SystemFile file, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        throw new UnsupportedOperationException("Can only be used in a Netty context");
    }

    public void writeTo(HttpRequest<?> request, MutableHttpResponse<SystemFile> response, SystemFile systemFile, NettyWriteContext nettyContext) throws CodecException {
        if (response instanceof NettyMutableHttpResponse) {
            NettyMutableHttpResponse nettyResponse = (NettyMutableHttpResponse)response;
            if (!systemFile.getFile().canRead()) {
                throw new MessageBodyException("Could not find file");
            }
            if (this.handleIfModifiedAndHeaders(request, response, (FileCustomizableResponseType)systemFile, nettyResponse)) {
                nettyContext.writeFull(this.notModified(response));
            } else {
                FileInputStream is;
                long fileLength = systemFile.getLength();
                long position = 0L;
                long contentLength = fileLength;
                if (fileLength > -1L) {
                    IntRange range;
                    String rangeHeader = (String)request.getHeaders().get((CharSequence)"Range");
                    if (rangeHeader != null && request.getMethod() == HttpMethod.GET && rangeHeader.startsWith(UNIT_BYTES) && response.status() == HttpStatus.OK && (range = SystemFileBodyWriter.parseRangeHeader(rangeHeader, fileLength)) != null && range.firstPos < range.lastPos && range.firstPos < fileLength && range.lastPos < fileLength) {
                        position = range.firstPos;
                        contentLength = range.lastPos + 1L - range.firstPos;
                        response.status(HttpStatus.PARTIAL_CONTENT);
                        response.header((CharSequence)"Content-Range", (CharSequence)"%s %d-%d/%d".formatted(UNIT_BYTES, range.firstPos, range.lastPos, fileLength));
                    }
                    response.header((CharSequence)"Accept-Ranges", (CharSequence)UNIT_BYTES);
                    response.header((CharSequence)"Content-Length", (CharSequence)Long.toString(contentLength));
                } else {
                    response.header((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
                }
                DefaultHttpResponse finalResponse = new DefaultHttpResponse(nettyResponse.getNettyHttpVersion(), nettyResponse.getNettyHttpStatus(), nettyResponse.getNettyHeaders());
                File file = systemFile.getFile();
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new MessageBodyException("Could not find file", (Throwable)e);
                }
                nettyContext.writeStream((HttpResponse)finalResponse, (InputStream)new RangeInputStream(is, position, contentLength), this.ioExecutor);
            }
        } else {
            throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
        }
    }

    @Nullable
    private static IntRange parseRangeHeader(String value, long contentLength) {
        int equalsIdx = value.indexOf(61);
        if (equalsIdx < 0 || equalsIdx == value.length() - 1) {
            return null;
        }
        int minusIdx = value.indexOf(45, equalsIdx + 1);
        if (minusIdx < 0) {
            return null;
        }
        String from = value.substring(equalsIdx + 1, minusIdx).trim();
        String to = value.substring(minusIdx + 1).trim();
        try {
            long fromPosition = from.isEmpty() ? 0L : Long.parseLong(from);
            long toPosition = to.isEmpty() ? contentLength - 1L : Long.parseLong(to);
            return new IntRange(fromPosition, toPosition);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class IntRange {
        private final long firstPos;
        private final long lastPos;

        IntRange(long firstPos, long lastPos) {
            this.firstPos = firstPos;
            this.lastPos = lastPos;
        }
    }

    private static final class RangeInputStream
    extends InputStream {
        private final InputStream delegate;
        private final long toSkip;
        private long remainingLength;
        private boolean skipped = false;
        private boolean skipSuccess = false;

        private RangeInputStream(InputStream delegate, long toSkip, long length) {
            this.delegate = delegate;
            this.toSkip = toSkip;
            this.remainingLength = length;
            if (toSkip == 0L) {
                this.skipped = true;
                this.skipSuccess = true;
            }
        }

        private boolean doSkip() throws IOException {
            if (!this.skipped) {
                this.skipped = true;
                try {
                    this.delegate.skipNBytes(this.toSkip);
                    this.skipSuccess = true;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            return this.skipSuccess;
        }

        @Override
        public int read() throws IOException {
            if (!this.doSkip()) {
                return -1;
            }
            if (this.remainingLength <= 0L) {
                return -1;
            }
            int read = this.delegate.read();
            if (read != -1) {
                --this.remainingLength;
            }
            return read;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            int n;
            if (!this.doSkip()) {
                return -1;
            }
            if (this.remainingLength <= 0L) {
                return -1;
            }
            if ((long)len > this.remainingLength) {
                len = (int)this.remainingLength;
            }
            if ((n = this.delegate.read(b, off, len)) != -1) {
                this.remainingLength -= (long)n;
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

