/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.io.IOException;
import org.junit.jupiter.api.Test;

public class LocalErrorReadingBodyTest {
    public static final String SPEC_NAME = "LocalErrorReadingBodyTest";

    @Test
    void jsonSyntaxErrorBodyAccessible() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/json/jsonBody", (Object)"{\"numberField\": \"textInsteadOf"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).body("Syntax error: {\"numberField\": \"textInsteadOf").build()));
    }

    @Controller(value="/json")
    @Requires(property="spec.name", value="LocalErrorReadingBodyTest")
    static class JsonController {
        JsonController() {
        }

        @Post(value="/jsonBody")
        String jsonBody(@Valid @Body RequestObject data) {
            return "blah";
        }

        @Error
        @Produces(value={"application/json"})
        @Status(value=HttpStatus.BAD_REQUEST)
        String syntaxErrorHandler(@Body @Nullable String body) {
            return "Syntax error: " + body;
        }
    }

    @Introspected
    static class RequestObject {
        @Min(value=1L)
        private @Min(value=1L) Integer numberField;

        public RequestObject(Integer numberField) {
            this.numberField = numberField;
        }

        public Integer getNumberField() {
            return this.numberField;
        }
    }
}

