/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.context;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.context.ClientContextPathProvider;
import io.micronaut.http.context.ServerContextPathProvider;
import java.net.URI;
import java.net.URISyntaxException;

public final class ContextPathUtils {
    private ContextPathUtils() {
    }

    @NonNull
    public static URI prepend(@NonNull URI requestURI, @Nullable ServerContextPathProvider serverContextPathProvider) throws URISyntaxException {
        return ContextPathUtils.prepend(requestURI, serverContextPathProvider.getContextPath());
    }

    @NonNull
    public static URI prepend(@NonNull URI requestURI, @Nullable ClientContextPathProvider clientContextPathProvider) throws URISyntaxException {
        return ContextPathUtils.prepend(requestURI, clientContextPathProvider.getContextPath().orElse(null));
    }

    @NonNull
    public static URI prepend(@NonNull URI requestURI, @Nullable String contextPath) throws URISyntaxException {
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            return new URI(StringUtils.prependUri((String)contextPath, (String)requestURI.toString()));
        }
        return requestURI;
    }
}

