/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.transaction.spring;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.test.transaction.TestTransactionInterceptor;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Requires(classes={PlatformTransactionManager.class})
@EachBean(value=PlatformTransactionManager.class)
public class SpringTestTransactionInterceptor
implements TestTransactionInterceptor {
    private final PlatformTransactionManager transactionManager;
    private TransactionStatus tx;
    private final AtomicInteger counter = new AtomicInteger();

    public SpringTestTransactionInterceptor(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void begin() {
        if (this.counter.getAndIncrement() == 0) {
            this.tx = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        }
    }

    @Override
    public void commit() {
        if (this.counter.decrementAndGet() == 0) {
            this.transactionManager.commit(this.tx);
        }
    }

    @Override
    public void rollback() {
        if (this.counter.decrementAndGet() == 0) {
            this.transactionManager.rollback(this.tx);
        }
    }
}

