/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.netty.ChannelBindException;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.DisposableServer;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbortedException;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpResources;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.InetSocketAddressUtil;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpResources;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerRunOn;
import reactor.netty.tcp.TcpUtils;

final class TcpServerBind
extends TcpServer {
    static final TcpServerBind INSTANCE = new TcpServerBind();
    final ServerBootstrap serverBootstrap = this.createServerBootstrap();

    TcpServerBind() {
        BootstrapHandlers.channelOperationFactory(this.serverBootstrap, TcpUtils.TCP_OPS);
    }

    @Override
    public Mono<? extends DisposableServer> bind(ServerBootstrap b) {
        SslProvider ssl = SslProvider.findSslSupport(b);
        if (ssl != null && ssl.getDefaultConfigurationType() == null) {
            ssl = SslProvider.updateDefaultConfiguration(ssl, SslProvider.DefaultConfigurationType.TCP);
            SslProvider.setBootstrap(b, ssl);
        }
        if (b.config().group() == null) {
            TcpServerRunOn.configure(b, LoopResources.DEFAULT_NATIVE, TcpResources.get());
        }
        return Mono.create(sink -> {
            ServerBootstrap bootstrap = b.clone();
            ConnectionObserver obs = BootstrapHandlers.connectionObserver(bootstrap);
            ConnectionObserver childObs = BootstrapHandlers.childConnectionObserver(bootstrap);
            ChannelOperations.OnSetup ops = BootstrapHandlers.channelOperationFactory(bootstrap);
            TcpServerBind.convertLazyLocalAddress(bootstrap);
            BootstrapHandlers.finalizeHandler(bootstrap, ops, (ConnectionObserver)new ChildObserver(childObs));
            ChannelFuture f = bootstrap.bind();
            DisposableBind disposableServer = new DisposableBind((MonoSink<DisposableServer>)sink, f, obs, bootstrap);
            f.addListener((GenericFutureListener)disposableServer);
            sink.onCancel((Disposable)disposableServer);
        });
    }

    @Override
    public ServerBootstrap configure() {
        return this.serverBootstrap.clone();
    }

    static void convertLazyLocalAddress(ServerBootstrap b) {
        InetSocketAddress localInet;
        SocketAddress local = b.config().localAddress();
        Objects.requireNonNull(local, "Remote Address not configured");
        if (local instanceof Supplier) {
            Supplier lazyLocal = (Supplier)((Object)local);
            b.localAddress(Objects.requireNonNull((SocketAddress)lazyLocal.get(), "address supplier returned  null"));
        }
        if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
            b.localAddress((SocketAddress)InetSocketAddressUtil.createResolved(localInet.getHostName(), localInet.getPort()));
        }
    }

    ServerBootstrap createServerBootstrap() {
        return (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.AUTO_READ, (Object)false).childOption(ChannelOption.TCP_NODELAY, (Object)true).localAddress((SocketAddress)new InetSocketAddress(0));
    }

    static final class ChildObserver
    implements ConnectionObserver {
        final ConnectionObserver childObs;

        ChildObserver(ConnectionObserver childObs) {
            this.childObs = childObs;
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            ChannelOperations<?, ?> ops = ChannelOperations.get(connection.channel());
            if (ops == null && (error instanceof IOException || AbortedException.isConnectionReset(error))) {
                if (TcpServer.log.isDebugEnabled()) {
                    TcpServer.log.debug(ReactorNetty.format(connection.channel(), "onUncaughtException(" + connection + ")"), error);
                }
            } else {
                TcpServer.log.error(ReactorNetty.format(connection.channel(), "onUncaughtException(" + connection + ")"), error);
            }
            connection.dispose();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive() && !connection.isPersistent()) {
                connection.dispose();
            }
            this.childObs.onStateChange(connection, newState);
        }
    }

    static final class DisposableBind
    implements Disposable,
    ChannelFutureListener,
    DisposableServer,
    Connection {
        final MonoSink<DisposableServer> sink;
        final ChannelFuture f;
        final ServerBootstrap bootstrap;
        final ConnectionObserver selectorObserver;

        DisposableBind(MonoSink<DisposableServer> sink, ChannelFuture f, ConnectionObserver selectorObserver, ServerBootstrap bootstrap) {
            this.sink = sink;
            this.bootstrap = bootstrap;
            this.f = f;
            this.selectorObserver = selectorObserver;
        }

        @Override
        public final void dispose() {
            this.f.removeListener((GenericFutureListener)this);
            if (this.f.channel().isActive()) {
                this.f.channel().close();
                HttpResources.get().disposeWhen(this.bootstrap.config().localAddress());
            } else if (!this.f.isDone()) {
                this.f.cancel(true);
            }
        }

        @Override
        public Channel channel() {
            return this.f.channel();
        }

        public final void operationComplete(ChannelFuture f) {
            if (!f.isSuccess()) {
                if (f.isCancelled()) {
                    if (TcpServer.log.isDebugEnabled()) {
                        TcpServer.log.debug(ReactorNetty.format(f.channel(), "Channel cancelled"));
                    }
                    return;
                }
                this.sink.error((Throwable)ChannelBindException.fail(this.bootstrap, f.cause()));
            } else {
                if (TcpServer.log.isDebugEnabled()) {
                    TcpServer.log.debug(ReactorNetty.format(f.channel(), "Bound new server"));
                }
                this.sink.success((Object)this);
                this.selectorObserver.onStateChange(this, ConnectionObserver.State.CONNECTED);
            }
        }
    }
}

