/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import java.util.Objects;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerOperator;

final class TcpServerRunOn
extends TcpServerOperator {
    final LoopResources loopResources;
    final boolean preferNative;

    TcpServerRunOn(TcpServer server, LoopResources loopResources, boolean preferNative) {
        super(server);
        this.loopResources = Objects.requireNonNull(loopResources, "loopResources");
        this.preferNative = preferNative;
    }

    @Override
    public ServerBootstrap configure() {
        ServerBootstrap b = this.source.configure();
        TcpServerRunOn.configure(b, this.preferNative, this.loopResources);
        return b;
    }

    static void configure(ServerBootstrap b, boolean preferNative, LoopResources resources) {
        EventLoopGroup selectorGroup = resources.onServerSelect(preferNative);
        EventLoopGroup elg = resources.onServer(preferNative);
        b.group(selectorGroup, elg).channel(resources.onServerChannel(elg));
    }
}

