/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.logger;

import java.util.logging.Level;

public class Logger {
    private final java.util.logging.Logger LOGGER;
    private final boolean JMX_PROMETHEUS_EXPORTER_DEVELOPER_DEBUG = "true".equals(System.getenv("JMX_PROMETHEUS_EXPORTER_DEVELOPER_DEBUG")) || "true".equals(System.getProperty("jmx.prometheus.exporter.developer.debug"));

    Logger(Class<?> clazz) {
        this.LOGGER = java.util.logging.Logger.getLogger(clazz.getName());
    }

    public boolean isLoggable(Level level) {
        return this.LOGGER.isLoggable(level);
    }

    public void log(Level level, String message, Object ... objects) {
        if (this.LOGGER.isLoggable(level)) {
            this.LOGGER.log(level, String.format(message, objects));
        }
        if (this.JMX_PROMETHEUS_EXPORTER_DEVELOPER_DEBUG) {
            System.out.format("[%s] %s %s", level, this.LOGGER.getName(), String.format(message, objects)).println();
        }
    }
}

