/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="go-offline")
public class GoOfflineMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepositoryManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        DependencyNode root;
        DefaultArtifact pom = new DefaultArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifactId(), "pom", this.project.getVersion());
        MavenArtifactResolver resolver = this.getResolver();
        try {
            root = resolver.collectDependencies((Artifact)pom, Collections.emptyList()).getRoot();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to collect dependencies of " + (Artifact)pom, e);
        }
        ArrayList<Path> createdDirs = new ArrayList<Path>();
        try {
            GoOfflineMojo.ensureResolvableModule(root, resolver.getMavenContext().getWorkspace(), createdDirs);
            GACTV appArtifact = new GACTV(pom.getGroupId(), pom.getArtifactId(), pom.getClassifier(), pom.getExtension(), pom.getVersion());
            this.resolveAppModel(resolver, (ArtifactCoords)appArtifact, LaunchMode.NORMAL);
            this.resolveAppModel(resolver, (ArtifactCoords)appArtifact, LaunchMode.DEVELOPMENT);
            this.resolveAppModel(resolver, (ArtifactCoords)appArtifact, LaunchMode.TEST);
        }
        finally {
            for (Path d : createdDirs) {
                IoUtils.recursiveDelete((Path)d);
            }
        }
    }

    private void resolveAppModel(MavenArtifactResolver resolver, ArtifactCoords appArtifact, LaunchMode mode) throws MojoExecutionException {
        BootstrapAppModelResolver appModelResolver = new BootstrapAppModelResolver(resolver);
        if (mode == LaunchMode.DEVELOPMENT) {
            appModelResolver.setDevMode(true);
        } else if (mode == LaunchMode.TEST) {
            appModelResolver.setTest(true);
        }
        try {
            appModelResolver.resolveModel(appArtifact);
        }
        catch (AppModelResolverException e) {
            throw new MojoExecutionException("Failed to resolve Quarkus application model for " + this.project.getArtifact(), (Exception)((Object)e));
        }
    }

    private MavenArtifactResolver getResolver() throws MojoExecutionException {
        try {
            return ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositoryManager(this.remoteRepositoryManager)).setRemoteRepositories(this.repos)).setPreferPomsFromWorkspace(true)).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }

    private static void ensureResolvableModule(DependencyNode node, LocalWorkspace workspace, List<Path> createdDirs) throws MojoExecutionException {
        Path classesDir;
        LocalProject module;
        Artifact artifact = node.getArtifact();
        if (artifact != null && (module = workspace.getProject(artifact.getGroupId(), artifact.getArtifactId())) != null && !module.getRawModel().getPackaging().equals("pom") && !Files.exists(classesDir = module.getClassesDir(), new LinkOption[0])) {
            Path topDirToCreate = classesDir;
            while (!Files.exists(topDirToCreate.getParent(), new LinkOption[0])) {
                topDirToCreate = topDirToCreate.getParent();
            }
            try {
                Files.createDirectories(classesDir, new FileAttribute[0]);
                createdDirs.add(topDirToCreate);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create " + classesDir, (Exception)e);
            }
        }
        for (DependencyNode c : node.getChildren()) {
            GoOfflineMojo.ensureResolvableModule(c, workspace, createdDirs);
        }
    }
}

