/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.maven.QuarkusProjectMojoBase;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.transfer.TransferListener;

public abstract class QuarkusProjectStateMojoBase
extends QuarkusProjectMojoBase {
    @Parameter(property="perModule", required=false)
    boolean perModule;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(QuarkusProject quarkusProject, MessageWriter log) throws MojoExecutionException {
        if (this.project.getFile() == null) {
            throw new MojoExecutionException("This goal requires a project");
        }
        if (!QuarkusProjectHelper.isRegistryClientEnabled()) {
            throw new MojoExecutionException("This goal requires a Quarkus extension registry client to be enabled");
        }
        String emb = System.getProperty("quarkus.bootstrap.effective-model-builder");
        System.setProperty("quarkus.bootstrap.effective-model-builder", "true");
        Collection<Path> createdDirs = this.ensureResolvable((Artifact)new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), "pom", this.project.getVersion()));
        try {
            this.processProjectState(quarkusProject);
        }
        finally {
            if (emb == null) {
                System.clearProperty("quarkus.bootstrap.effective-model-builder");
            } else {
                System.setProperty("quarkus.bootstrap.effective-model-builder", emb);
            }
            for (Path p : createdDirs) {
                IoUtils.recursiveDelete((Path)p);
            }
        }
    }

    protected abstract void processProjectState(QuarkusProject var1) throws MojoExecutionException;

    protected ApplicationModel resolveApplicationModel() throws MojoExecutionException {
        try {
            return new BootstrapAppModelResolver(this.artifactResolver()).resolveModel(ArtifactCoords.pom((String)this.project.getGroupId(), (String)this.project.getArtifactId(), (String)this.project.getVersion()));
        }
        catch (AppModelResolverException e) {
            throw new MojoExecutionException("Failed to resolve the Quarkus application model for project " + ArtifactCoords.pom((String)this.project.getGroupId(), (String)this.project.getArtifactId(), (String)this.project.getVersion()), (Exception)((Object)e));
        }
    }

    private Collection<Path> ensureResolvable(Artifact a) throws MojoExecutionException {
        DependencyNode root;
        try {
            root = this.artifactResolver().collectDependencies(a, Collections.emptyList()).getRoot();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to collect dependencies of " + a, e);
        }
        ArrayList<Path> createdDirs = new ArrayList<Path>();
        this.ensureResolvableModule(root, this.artifactResolver().getMavenContext().getWorkspace(), createdDirs);
        return createdDirs;
    }

    private void ensureResolvableModule(DependencyNode node, LocalWorkspace workspace, List<Path> createdDirs) throws MojoExecutionException {
        Path classesDir;
        LocalProject module;
        Artifact artifact = node.getArtifact();
        if (artifact != null && (module = workspace.getProject(artifact.getGroupId(), artifact.getArtifactId())) != null && !module.getRawModel().getPackaging().equals("pom") && !Files.exists(classesDir = module.getClassesDir(), new LinkOption[0])) {
            Path topDirToCreate = classesDir;
            while (!Files.exists(topDirToCreate.getParent(), new LinkOption[0])) {
                topDirToCreate = topDirToCreate.getParent();
            }
            try {
                Files.createDirectories(classesDir, new FileAttribute[0]);
                createdDirs.add(topDirToCreate);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create " + classesDir, (Exception)e);
            }
        }
        for (DependencyNode c : node.getChildren()) {
            this.ensureResolvableModule(c, workspace, createdDirs);
        }
    }

    @Override
    protected MavenArtifactResolver catalogArtifactResolver() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            return this.artifactResolver();
        }
        try {
            MavenArtifactResolver baseResolver = this.artifactResolver();
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(baseResolver.getSession());
            session.setTransferListener((TransferListener)new QuietMavenTransferListener());
            BootstrapMavenContext ctx = new BootstrapMavenContext(BootstrapMavenContext.config().setRepositorySystem(baseResolver.getSystem()).setRemoteRepositoryManager(baseResolver.getRemoteRepositoryManager()).setRemoteRepositories(baseResolver.getRepositories()).setWorkspaceDiscovery(false).setRepositorySystemSession((RepositorySystemSession)session));
            return new MavenArtifactResolver(ctx);
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }

    @Override
    protected MavenArtifactResolver initArtifactResolver() throws MojoExecutionException {
        try {
            return ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositoryManager(this.remoteRepositoryManager)).setRemoteRepositories(this.repos)).setPreferPomsFromWorkspace(true)).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }
}

