/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.maven.QuarkusBootstrapMojo;
import io.quarkus.maven.components.ManifestSection;
import io.quarkus.maven.components.QuarkusWorkspaceProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedArtifactDependency;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.common.expression.Expression;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.RemoteRepositoryManager;

@Singleton
@Named
public class QuarkusBootstrapProvider
implements Closeable {
    private static final String MANIFEST_SECTIONS_PROPERTY_PREFIX = "quarkus.package.manifest.manifest-sections";
    private static final String MANIFEST_ATTRIBUTES_PROPERTY_PREFIX = "quarkus.package.manifest.attributes";
    private final QuarkusWorkspaceProvider workspaceProvider;
    private final RepositorySystem repoSystem;
    private final RemoteRepositoryManager remoteRepoManager;
    private final Cache<String, QuarkusMavenAppBootstrap> appBootstrapProviders = CacheBuilder.newBuilder().concurrencyLevel(4).softValues().initialCapacity(10).build();

    @Inject
    public QuarkusBootstrapProvider(RepositorySystem repoSystem, RemoteRepositoryManager remoteRepoManager, QuarkusWorkspaceProvider workspaceProvider) {
        this.repoSystem = repoSystem;
        this.remoteRepoManager = remoteRepoManager;
        this.workspaceProvider = workspaceProvider;
    }

    static ArtifactKey getProjectId(MavenProject project) {
        return ArtifactKey.ga((String)project.getGroupId(), (String)project.getArtifactId());
    }

    static Map<Path, Model> getProjectMap(MavenSession session) {
        List allProjects = session.getAllProjects();
        if (allProjects == null) {
            return Map.of();
        }
        HashMap<Path, Model> projectModels = new HashMap<Path, Model>(allProjects.size());
        for (MavenProject mp : allProjects) {
            Model model = mp.getOriginalModel();
            model.setPomFile(mp.getFile());
            model.setBuild(mp.getModel().getBuild());
            projectModels.put(mp.getBasedir().toPath(), model);
            File pomDir = mp.getFile().getParentFile();
            if (pomDir.equals(mp.getBasedir())) continue;
            projectModels.put(pomDir.toPath(), model);
        }
        return projectModels;
    }

    private static String getBootstrapProviderId(ArtifactKey moduleKey, String bootstrapId) {
        return bootstrapId == null ? moduleKey.toGacString() : moduleKey.toGacString() + "-" + bootstrapId;
    }

    @Deprecated(forRemoval=true)
    public RepositorySystem repositorySystem() {
        return this.workspaceProvider.getRepositorySystem();
    }

    @Deprecated(forRemoval=true)
    public RemoteRepositoryManager remoteRepositoryManager() {
        return this.remoteRepoManager;
    }

    public QuarkusMavenAppBootstrap bootstrapper(QuarkusBootstrapMojo mojo) {
        try {
            return (QuarkusMavenAppBootstrap)this.appBootstrapProviders.get((Object)QuarkusBootstrapProvider.getBootstrapProviderId(mojo.projectId(), mojo.bootstrapId()), () -> new QuarkusMavenAppBootstrap());
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to cache a new instance of " + QuarkusMavenAppBootstrap.class.getName(), e);
        }
    }

    public CuratedApplication bootstrapApplication(QuarkusBootstrapMojo mojo, LaunchMode mode) throws MojoExecutionException {
        return this.bootstrapper(mojo).bootstrapApplication(mojo, mode);
    }

    public ApplicationModel getResolvedApplicationModel(ArtifactKey projectId, LaunchMode mode, String bootstrapId) {
        if (this.appBootstrapProviders.size() == 0L) {
            return null;
        }
        QuarkusMavenAppBootstrap provider = (QuarkusMavenAppBootstrap)this.appBootstrapProviders.getIfPresent((Object)QuarkusBootstrapProvider.getBootstrapProviderId(projectId, bootstrapId));
        if (provider == null) {
            return null;
        }
        if (mode == LaunchMode.DEVELOPMENT) {
            return provider.devApp == null ? null : provider.devApp.getApplicationModel();
        }
        if (mode == LaunchMode.TEST) {
            return provider.testApp == null ? null : provider.testApp.getApplicationModel();
        }
        return provider.prodApp == null ? null : provider.prodApp.getApplicationModel();
    }

    @Override
    public void close() throws IOException {
        if (this.appBootstrapProviders.size() == 0L) {
            return;
        }
        for (QuarkusMavenAppBootstrap p : this.appBootstrapProviders.asMap().values()) {
            try {
                p.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isWorkspaceDiscovery(QuarkusBootstrapMojo mojo) {
        String v = System.getProperty("quarkus.bootstrap.workspace-discovery");
        if (v == null) {
            v = mojo.mavenProject().getProperties().getProperty("quarkus.bootstrap.workspace-discovery");
        }
        return Boolean.parseBoolean(v);
    }

    public class QuarkusMavenAppBootstrap
    implements Closeable {
        private CuratedApplication prodApp;
        private CuratedApplication devApp;
        private CuratedApplication testApp;

        private MavenArtifactResolver artifactResolver(QuarkusBootstrapMojo mojo, LaunchMode mode) throws MojoExecutionException {
            try {
                block5: {
                    block4: {
                        if (mode == LaunchMode.DEVELOPMENT || mode == LaunchMode.TEST) break block4;
                        if (!QuarkusBootstrapProvider.isWorkspaceDiscovery(mojo)) break block5;
                    }
                    return QuarkusBootstrapProvider.this.workspaceProvider.createArtifactResolver(BootstrapMavenContext.config().setCurrentProject(mojo.mavenProject().getFile().toString()).setPreferPomsFromWorkspace(true).setProjectModelProvider(QuarkusBootstrapProvider.getProjectMap(mojo.mavenSession())::get));
                }
                return ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(false)).setRepositorySystem(QuarkusBootstrapProvider.this.repoSystem)).setRepositorySystemSession(mojo.repositorySystemSession())).setRemoteRepositories(mojo.remoteRepositories())).setRemoteRepositoryManager(QuarkusBootstrapProvider.this.remoteRepoManager)).build();
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to initialize Quarkus bootstrap Maven artifact resolver", (Exception)((Object)e));
            }
        }

        private CuratedApplication doBootstrap(QuarkusBootstrapMojo mojo, LaunchMode mode) throws MojoExecutionException {
            ApplicationModel appModel;
            BootstrapAppModelResolver modelResolver = new BootstrapAppModelResolver(this.artifactResolver(mojo, mode)).setDevMode(mode == LaunchMode.DEVELOPMENT).setTest(mode == LaunchMode.TEST).setCollectReloadableDependencies(mode == LaunchMode.DEVELOPMENT || mode == LaunchMode.TEST);
            ArtifactCoords appArtifact = this.appArtifact(mojo);
            Set<ArtifactKey> reloadableModules = Set.of();
            if (mode == LaunchMode.NORMAL) {
                List localProjects = mojo.mavenProject().getCollectedProjects();
                HashSet<ArtifactKey> localProjectKeys = new HashSet<ArtifactKey>(localProjects.size());
                for (MavenProject p : localProjects) {
                    localProjectKeys.add(ArtifactKey.ga((String)p.getGroupId(), (String)p.getArtifactId()));
                }
                reloadableModules = new HashSet(localProjects.size() + 1);
                for (Artifact a : mojo.mavenProject().getArtifacts()) {
                    if (!localProjectKeys.contains(ArtifactKey.ga((String)a.getGroupId(), (String)a.getArtifactId()))) continue;
                    reloadableModules.add(ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getType()));
                }
                reloadableModules.add(appArtifact.getKey());
            }
            List<Dependency> forcedDependencies = mojo.forcedDependencies(mode);
            try {
                appModel = modelResolver.resolveManagedModel(appArtifact, forcedDependencies, this.managingProject(mojo), reloadableModules);
            }
            catch (AppModelResolverException e) {
                throw new MojoExecutionException("Failed to bootstrap application in " + mode + " mode", (Exception)((Object)e));
            }
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setAppArtifact(appModel.getAppArtifact()).setExistingModel(appModel).setIsolateDeployment(true).setBaseClassLoader(this.getClass().getClassLoader()).setBuildSystemProperties(this.getBuildSystemProperties(mojo, true)).setProjectRoot(mojo.baseDir().toPath()).setBaseName(mojo.finalName()).setOriginalBaseName(mojo.mavenProject().getBuild().getFinalName()).setTargetDirectory(mojo.buildDir().toPath()).setForcedDependencies(forcedDependencies);
            try {
                return builder.build().bootstrap();
            }
            catch (BootstrapException e) {
                throw new MojoExecutionException("Failed to bootstrap the application", (Exception)((Object)e));
            }
        }

        public Properties getBuildSystemProperties(QuarkusBootstrapMojo mojo, boolean quarkusOnly) throws MojoExecutionException {
            Properties effectiveProperties = new Properties();
            if (mojo.ignoredEntries() != null && mojo.ignoredEntries().length > 0) {
                String joinedEntries = String.join((CharSequence)",", mojo.ignoredEntries());
                effectiveProperties.setProperty("quarkus.package.user-configured-ignored-entries", joinedEntries);
            }
            Properties projectProperties = mojo.mavenProject().getProperties();
            for (String string : projectProperties.stringPropertyNames()) {
                if (quarkusOnly && !string.startsWith("quarkus.")) continue;
                effectiveProperties.setProperty(string, projectProperties.getProperty(string));
            }
            effectiveProperties.putAll(mojo.properties());
            effectiveProperties.putIfAbsent("quarkus.application.name", mojo.mavenProject().getArtifactId());
            effectiveProperties.putIfAbsent("quarkus.application.version", mojo.mavenProject().getVersion());
            for (Map.Entry entry : mojo.manifestEntries().entrySet()) {
                if (entry.getValue() == null) {
                    mojo.getLog().warn((CharSequence)("Skipping manifest entry property " + (String)entry.getKey() + " with a missing value"));
                    continue;
                }
                effectiveProperties.put(this.toManifestAttributeKey((String)entry.getKey()), entry.getValue());
            }
            for (ManifestSection manifestSection : mojo.manifestSections()) {
                for (Map.Entry<String, String> attribute : manifestSection.getManifestEntries().entrySet()) {
                    effectiveProperties.put(this.toManifestSectionAttributeKey(manifestSection.getName(), attribute.getKey()), attribute.getValue());
                }
            }
            for (Object object : effectiveProperties.values()) {
                for (String reference : Expression.compile((String)((String)object), (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM}).getReferencedStrings()) {
                    String referenceValue = mojo.mavenSession().getUserProperties().getProperty(reference);
                    if (referenceValue != null) {
                        effectiveProperties.setProperty(reference, referenceValue);
                        continue;
                    }
                    referenceValue = projectProperties.getProperty(reference);
                    if (referenceValue == null) continue;
                    effectiveProperties.setProperty(reference, referenceValue);
                }
            }
            return effectiveProperties;
        }

        private String toManifestAttributeKey(String key) throws MojoExecutionException {
            if (key.contains("\"")) {
                throw new MojoExecutionException("Manifest entry name " + key + " is invalid. \" characters are not allowed.");
            }
            return String.format("%s.\"%s\"", QuarkusBootstrapProvider.MANIFEST_ATTRIBUTES_PROPERTY_PREFIX, key);
        }

        private String toManifestSectionAttributeKey(String section, String key) throws MojoExecutionException {
            if (section.contains("\"")) {
                throw new MojoExecutionException("Manifest section name " + section + " is invalid. \" characters are not allowed.");
            }
            if (key.contains("\"")) {
                throw new MojoExecutionException("Manifest entry name " + key + " is invalid. \" characters are not allowed.");
            }
            return String.format("%s.\"%s\".\"%s\"", QuarkusBootstrapProvider.MANIFEST_SECTIONS_PROPERTY_PREFIX, section, key);
        }

        protected CuratedApplication bootstrapApplication(QuarkusBootstrapMojo mojo, LaunchMode mode) throws MojoExecutionException {
            if (mode == LaunchMode.DEVELOPMENT) {
                return this.devApp == null ? (this.devApp = this.doBootstrap(mojo, mode)) : this.devApp;
            }
            if (mode == LaunchMode.TEST) {
                return this.testApp == null ? (this.testApp = this.doBootstrap(mojo, mode)) : this.testApp;
            }
            return this.prodApp == null ? (this.prodApp = this.doBootstrap(mojo, mode)) : this.prodApp;
        }

        protected ArtifactCoords managingProject(QuarkusBootstrapMojo mojo) {
            if (mojo.appArtifactCoords() == null) {
                return null;
            }
            Artifact artifact = mojo.mavenProject().getArtifact();
            return ArtifactCoords.of((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier(), (String)artifact.getArtifactHandler().getExtension(), (String)artifact.getVersion());
        }

        private ArtifactCoords appArtifact(QuarkusBootstrapMojo mojo) throws MojoExecutionException {
            String appArtifactCoords = mojo.appArtifactCoords();
            if (appArtifactCoords == null) {
                Artifact projectArtifact = mojo.mavenProject().getArtifact();
                File projectFile = projectArtifact.getFile();
                if (projectFile == null && !(projectFile = new File(mojo.mavenProject().getBuild().getOutputDirectory())).exists() && !projectFile.mkdirs()) {
                    throw new MojoExecutionException("Failed to create the output dir " + projectFile);
                }
                return new ResolvedArtifactDependency(projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getClassifier(), projectArtifact.getArtifactHandler().getExtension(), projectArtifact.getVersion(), projectFile.toPath());
            }
            String[] coordsArr = appArtifactCoords.split(":");
            if (coordsArr.length < 2 || coordsArr.length > 5) {
                throw new MojoExecutionException("appArtifact expression " + appArtifactCoords + " does not follow format groupId:artifactId:classifier:type:version");
            }
            String groupId = coordsArr[0];
            String artifactId = coordsArr[1];
            String classifier = "";
            String type = "jar";
            String version = null;
            if (coordsArr.length == 3) {
                version = coordsArr[2];
            } else if (coordsArr.length > 3) {
                classifier = coordsArr[2] == null ? "" : coordsArr[2];
                String string = type = coordsArr[3] == null ? "jar" : coordsArr[3];
                if (coordsArr.length > 4) {
                    version = coordsArr[4];
                }
            }
            if (version == null) {
                for (Artifact dep : mojo.mavenProject().getArtifacts()) {
                    if (!dep.getArtifactId().equals(artifactId) || !dep.getGroupId().equals(groupId) || !dep.getClassifier().equals(classifier) || !dep.getType().equals(type)) continue;
                    version = dep.getVersion();
                    break;
                }
                if (version == null) {
                    throw new IllegalStateException("Failed to locate " + appArtifactCoords + " among the project dependencies");
                }
            }
            return ArtifactCoords.of((String)groupId, (String)artifactId, (String)classifier, (String)type, (String)version);
        }

        @Override
        public void close() {
            if (this.prodApp != null) {
                this.prodApp.close();
                this.prodApp = null;
            }
            if (this.devApp != null) {
                this.devApp.close();
                this.devApp = null;
            }
            if (this.testApp != null) {
                this.testApp.close();
                this.testApp = null;
            }
        }
    }
}

