/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.analytics.AnalyticsService;
import io.quarkus.analytics.config.FileLocationsImpl;
import io.quarkus.analytics.dto.segment.TrackEventType;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.platform.tools.maven.MojoMessageWriter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.rtinfo.RuntimeInformation;

@Singleton
@Named
public class BuildAnalyticsProvider {
    private RuntimeInformation runtimeInformation;
    private AnalyticsService analyticsService;
    private Log log;

    @Inject
    public BuildAnalyticsProvider(RuntimeInformation runtimeInformation) {
        this.runtimeInformation = runtimeInformation;
        this.analyticsService = new AnalyticsService(FileLocationsImpl.INSTANCE, (MessageWriter)new MojoMessageWriter(this.getLog()));
    }

    public void sendAnalytics(TrackEventType trackEventType, ApplicationModel applicationModel, Map<String, String> graalVMInfo, File localBuildDir) {
        long start = System.currentTimeMillis();
        HashMap<String, String> buildInfo = new HashMap<String, String>();
        buildInfo.putAll(graalVMInfo);
        buildInfo.put("maven.version", this.runtimeInformation.getMavenVersion());
        this.analyticsService.sendAnalytics(trackEventType, applicationModel, buildInfo, localBuildDir);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Analytics took " + (System.currentTimeMillis() - start) + "ms"));
        }
    }

    public void buildAnalyticsUserInput(Function<String, String> analyticsEnabledSupplier) {
        this.analyticsService.buildAnalyticsUserInput(analyticsEnabledSupplier);
    }

    public void close() {
        this.analyticsService.close();
    }

    private Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }
}

