/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.InterceptorResolverBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;

public class WrongAnnotationUsageProcessor {
    @BuildStep
    void detect(ArcConfig config, ApplicationIndexBuildItem applicationIndex, CustomScopeAnnotationsBuildItem scopeAnnotations, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, InterceptorResolverBuildItem interceptorResolverBuildItem) {
        if (!config.detectWrongAnnotations) {
            return;
        }
        Index index = applicationIndex.getIndex();
        ArrayList<UnsupportedAnnotation> unsupported = new ArrayList<UnsupportedAnnotation>();
        String correctSingleton = "@jakarta.inject.Singleton";
        unsupported.add(new UnsupportedAnnotation("com.google.inject.Singleton", correctSingleton));
        unsupported.add(new UnsupportedAnnotation("jakarta.ejb.Singleton", correctSingleton));
        unsupported.add(new UnsupportedAnnotation("groovy.lang.Singleton", correctSingleton));
        String correctInject = "@jakarta.inject.Inject";
        unsupported.add(new UnsupportedAnnotation("javax.inject.Inject", correctInject));
        unsupported.add(new UnsupportedAnnotation("com.google.inject.Inject", correctInject));
        unsupported.add(new UnsupportedAnnotation("com.oracle.svm.core.annotate.Inject", correctInject));
        unsupported.add(new UnsupportedAnnotation("org.gradle.internal.impldep.javax.inject.Inject", correctInject));
        HashMap<AnnotationInstance, String> wrongUsages = new HashMap<AnnotationInstance, String>();
        for (UnsupportedAnnotation unsupportedAnnotation : unsupported) {
            for (AnnotationInstance annotationInstance : index.getAnnotations(unsupportedAnnotation.name)) {
                wrongUsages.put(annotationInstance, String.format("%s declared on %s, use %s instead", annotationInstance.toString(false), WrongAnnotationUsageProcessor.getTargetInfo(annotationInstance), unsupportedAnnotation.correctAnnotation));
            }
        }
        if (!wrongUsages.isEmpty()) {
            for (Map.Entry entry : wrongUsages.entrySet()) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException((String)entry.getValue())));
            }
        }
        for (ClassInfo classInfo : index.getKnownClasses()) {
            ClassInfo.NestingType nestingType = classInfo.nestingType();
            if (ClassInfo.NestingType.ANONYMOUS != nestingType && ClassInfo.NestingType.LOCAL != nestingType && (ClassInfo.NestingType.INNER != nestingType || Modifier.isStatic(classInfo.flags()))) continue;
            Collection<AnnotationInstance> classLevelAnnotations = transformedAnnotations.getAnnotations((AnnotationTarget)classInfo);
            if (scopeAnnotations.isScopeIn(classLevelAnnotations)) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The %s class %s has a scope annotation but it must be ignored per the CDI rules", classInfo.nestingType().toString(), classInfo.name().toString()))));
            } else if (Annotations.containsAny(classLevelAnnotations, interceptorResolverBuildItem.getInterceptorBindings())) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The %s class %s declares an interceptor binding but it must be ignored per CDI rules", classInfo.nestingType().toString(), classInfo.name().toString()))));
            }
            for (MethodInfo methodInfo : classInfo.methods()) {
                Collection<AnnotationInstance> methodAnnotations = transformedAnnotations.getAnnotations((AnnotationTarget)methodInfo);
                if (methodAnnotations.isEmpty()) continue;
                if (Annotations.contains(methodAnnotations, (DotName)DotNames.OBSERVES) || Annotations.contains(methodAnnotations, (DotName)DotNames.OBSERVES_ASYNC)) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The method %s in the %s class %s declares an observer method but it must be ignored per the CDI rules", methodInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
                    continue;
                }
                if (Annotations.contains(methodAnnotations, (DotName)DotNames.PRODUCES)) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The method %s in the %s class %s declares a producer but it must be ignored per the CDI rules", methodInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
                    continue;
                }
                if (Modifier.isStatic(methodInfo.flags()) || !Annotations.containsAny(methodAnnotations, interceptorResolverBuildItem.getInterceptorBindings())) continue;
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The method %s in the %s class %s declares an interceptor binding but it must be ignored per CDI rules", methodInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
            }
            for (FieldInfo fieldInfo : classInfo.fields()) {
                Collection<AnnotationInstance> fieldAnnotations = transformedAnnotations.getAnnotations((AnnotationTarget)fieldInfo);
                if (fieldAnnotations.isEmpty() || !Annotations.contains(fieldAnnotations, (DotName)DotNames.PRODUCES)) continue;
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The field %s in the %s class %s declares a producer but it must be ignored per the CDI rules", fieldInfo.name(), classInfo.nestingType().toString(), classInfo.name().toString()))));
            }
        }
    }

    private static String getTargetInfo(AnnotationInstance annotationInstance) {
        AnnotationTarget target = annotationInstance.target();
        switch (target.kind()) {
            case FIELD: {
                return target.asField().declaringClass().toString() + "." + target.asField().name();
            }
            case METHOD: {
                return target.asMethod().declaringClass().toString() + "." + target.asMethod().name() + "()";
            }
        }
        return target.toString();
    }

    private static class UnsupportedAnnotation {
        final DotName name;
        final String correctAnnotation;

        UnsupportedAnnotation(String name, String correctAnnotation) {
            this.name = DotName.createSimple((String)name);
            this.correctAnnotation = correctAnnotation;
        }
    }
}

