/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.runtime.util.ClassPathUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    public static Iterable<Class<?>> classesNamedIn(ClassLoader classLoader, String fileName) throws IOException, ClassNotFoundException {
        ArrayList list = new ArrayList();
        for (String className : ServiceUtil.classNamesNamedIn(classLoader, fileName)) {
            list.add(Class.forName(className, true, classLoader));
        }
        return Collections.unmodifiableList(list);
    }

    public static Set<String> classNamesNamedIn(ClassLoader classLoader, String fileName) throws IOException {
        LinkedHashSet classNames = new LinkedHashSet();
        ClassPathUtils.consumeAsStreams((ClassLoader)classLoader, (String)fileName, classFile -> {
            try (InputStreamReader reader = new InputStreamReader((InputStream)classFile, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(reader);){
                ServiceUtil.readStream(classNames, br);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return Collections.unmodifiableSet(classNames);
    }

    public static Set<String> classNamesNamedIn(Path path) throws IOException {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try (BufferedReader br = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ServiceUtil.readStream(set, br);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return Collections.emptySet();
        }
        return set;
    }

    private static void readStream(Set<String> classNames, BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            int commentMarkerIndex = line.indexOf(35);
            if (commentMarkerIndex >= 0) {
                line = line.substring(0, commentMarkerIndex);
            }
            if ((line = line.trim()).isEmpty()) continue;
            classNames.add(line);
        }
    }
}

