/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg;

import io.quarkus.deployment.pkg.ManifestConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@ConfigRoot
public class PackageConfig {
    @Deprecated
    public static final String JAR = BuiltInType.JAR.value;
    @Deprecated
    public static final String UBER_JAR = BuiltInType.UBER_JAR.value;
    @Deprecated
    public static final String FAST_JAR = BuiltInType.FAST_JAR.value;
    @Deprecated
    public static final String MUTABLE_JAR = BuiltInType.MUTABLE_JAR.value;
    @Deprecated
    public static final String LEGACY = BuiltInType.LEGACY.value;
    @Deprecated
    public static final String LEGACY_JAR = BuiltInType.LEGACY_JAR.value;
    @Deprecated
    public static final String NATIVE = BuiltInType.NATIVE.value;
    @Deprecated
    public static final String NATIVE_SOURCES = BuiltInType.NATIVE_SOURCES.value;
    @ConfigItem(defaultValue="jar")
    public String type;
    @ConfigItem
    public ManifestConfig manifest;
    @ConfigItem
    public Optional<String> mainClass;
    @ConfigItem
    public Optional<List<String>> userConfiguredIgnoredEntries;
    @ConfigItem
    public Optional<Set<String>> includedOptionalDependencies;
    @ConfigItem(defaultValue="false")
    public boolean filterOptionalDependencies;
    @ConfigItem(defaultValue="-runner")
    public String runnerSuffix;
    @ConfigItem(defaultValue="true")
    public boolean addRunnerSuffix;
    @ConfigItem
    public Optional<String> outputDirectory;
    @ConfigItem
    public Optional<String> outputName;
    @ConfigItem
    public boolean createAppcds;
    @ConfigItem
    public Optional<String> appcdsBuilderImage;
    @ConfigItem(defaultValue="true")
    public boolean appcdsUseContainer;
    @ConfigItem
    public Optional<String> userProvidersDirectory;
    @ConfigItem(defaultValue="true")
    public boolean includeDependencyList;
    @ConfigItem
    public QuiltFlowerConfig quiltflower;
    @ConfigItem
    public boolean writeTransformedBytecodeToBuildOutput;

    public boolean isAnyJarType() {
        return this.type.equalsIgnoreCase(BuiltInType.JAR.getValue()) || this.type.equalsIgnoreCase(BuiltInType.FAST_JAR.getValue()) || this.type.equalsIgnoreCase(BuiltInType.UBER_JAR.getValue()) || this.type.equalsIgnoreCase(BuiltInType.LEGACY_JAR.getValue()) || this.type.equalsIgnoreCase(BuiltInType.LEGACY.getValue()) || this.type.equalsIgnoreCase(BuiltInType.MUTABLE_JAR.getValue());
    }

    public boolean isFastJar() {
        return this.type.equalsIgnoreCase(BuiltInType.JAR.getValue()) || this.type.equalsIgnoreCase(BuiltInType.FAST_JAR.getValue()) || this.type.equalsIgnoreCase(BuiltInType.MUTABLE_JAR.getValue());
    }

    public boolean isLegacyJar() {
        return this.type.equalsIgnoreCase(BuiltInType.LEGACY_JAR.getValue()) || this.type.equalsIgnoreCase(BuiltInType.LEGACY.getValue());
    }

    public boolean isUberJar() {
        return this.type.equalsIgnoreCase(BuiltInType.UBER_JAR.getValue());
    }

    public String getRunnerSuffix() {
        return this.addRunnerSuffix ? this.runnerSuffix : "";
    }

    @ConfigGroup
    public static class QuiltFlowerConfig {
        @ConfigItem(defaultValue="false")
        public boolean enabled;
        @ConfigItem(defaultValue="1.8.1")
        public String version;
        @ConfigItem(defaultValue="${user.home}/.quarkus")
        public String jarDirectory;
    }

    public static enum BuiltInType {
        JAR("jar"),
        UBER_JAR("uber-jar"),
        FAST_JAR("fast-jar"),
        MUTABLE_JAR("mutable-jar"),
        LEGACY("legacy"),
        LEGACY_JAR("legacy-jar"),
        NATIVE("native"),
        NATIVE_SOURCES("native-sources");

        private final String value;

        private BuiltInType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static BuiltInType fromString(String value) {
            for (BuiltInType type : BuiltInType.values()) {
                if (!type.toString().equals(value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown Quarkus package type '" + value + "'");
        }
    }
}

