/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class ExecUtil {
    private static final Logger LOG = Logger.getLogger(ExecUtil.class);
    private static final Function<InputStream, Runnable> INFO_LOGGING = i -> new HandleOutput((InputStream)i);
    private static final Function<InputStream, Runnable> DEBUG_LOGGING = i -> new HandleOutput((InputStream)i, Logger.Level.DEBUG);
    private static final Function<InputStream, Runnable> SYSTEM_LOGGING = i -> new HandleOutput((InputStream)i);
    private static Function<InputStream, Runnable> SELECTED_LOGGING = INFO_LOGGING;
    private static final int PROCESS_CHECK_INTERVAL = 500;

    public static void useInfoLogging() {
        SELECTED_LOGGING = INFO_LOGGING;
    }

    public static void useDebugLogging() {
        SELECTED_LOGGING = DEBUG_LOGGING;
    }

    public static void useSystemLogging() {
        SELECTED_LOGGING = SYSTEM_LOGGING;
    }

    public static boolean exec(String command, String ... args) {
        return ExecUtil.exec(new File("."), command, args);
    }

    public static boolean execWithTimeout(Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(new File("."), timeout, command, args);
    }

    public static boolean exec(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, SELECTED_LOGGING, command, args);
    }

    public static boolean execWithTimeout(File directory, Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(directory, SELECTED_LOGGING, timeout, command, args);
    }

    public static boolean exec(File directory, Function<InputStream, Runnable> outputFilterFunction, String command, String ... args) {
        try {
            Function<InputStream, Runnable> loggingFunction = outputFilterFunction != null ? outputFilterFunction : INFO_LOGGING;
            Process process = ExecUtil.startProcess(directory, command, args);
            Thread t = new Thread(loggingFunction.apply(process.getInputStream()));
            t.setName("Process stdout");
            t.setDaemon(true);
            t.start();
            process.waitFor();
            ExecUtil.destroyProcess(process);
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static boolean execWithTimeout(File directory, Function<InputStream, Runnable> outputFilterFunction, Duration timeout, String command, String ... args) {
        try {
            Function<InputStream, Runnable> loggingFunction = outputFilterFunction != null ? outputFilterFunction : INFO_LOGGING;
            Process process = ExecUtil.startProcess(directory, command, args);
            Thread t = new Thread(loggingFunction.apply(process.getInputStream()));
            t.setName("Process stdout");
            t.setDaemon(true);
            t.start();
            process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            ExecUtil.destroyProcess(process);
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static boolean execWithDebugLogging(String command, String ... args) {
        return ExecUtil.execWithDebugLogging(new File("."), command, args);
    }

    public static boolean execWithDebugLogging(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, DEBUG_LOGGING, command, args);
    }

    public static boolean execWithSystemLogging(String command, String ... args) {
        return ExecUtil.execWithSystemLogging(new File("."), command, args);
    }

    public static boolean execWithSystemLogging(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, SYSTEM_LOGGING, command, args);
    }

    public static Process startProcess(File directory, String command, String ... args) {
        try {
            String[] cmd = new String[args.length + 1];
            cmd[0] = command;
            if (args.length > 0) {
                System.arraycopy(args, 0, cmd, 1, args.length);
            }
            return new ProcessBuilder(new String[0]).directory(directory).command(cmd).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
    }

    public static void destroyProcess(Process process) {
        process.destroy();
        int i = 0;
        while (process.isAlive() && i++ < 10) {
            try {
                process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        if (process.isAlive()) {
            process.destroyForcibly();
        }
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Optional<Logger.Level> logLevel;

        HandleOutput(InputStream is) {
            this(is, null);
        }

        HandleOutput(InputStream is, Logger.Level logLevel) {
            this.is = is;
            this.logLevel = Optional.ofNullable(logLevel);
        }

        @Override
        public void run() {
            try (InputStreamReader isr = new InputStreamReader(this.is);
                 BufferedReader reader = new BufferedReader(isr);){
                String line = reader.readLine();
                while (line != null) {
                    String l = line;
                    this.logLevel.ifPresentOrElse(level -> LOG.log(level, (Object)l), () -> System.out.println(l));
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                this.logLevel.ifPresentOrElse(level -> LOG.log(level, (Object)"Failed to handle output", (Throwable)e), () -> e.printStackTrace());
            }
        }
    }
}

