/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.tools.ConsoleMessageFormats;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AddExtensionsCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue(AddExtensions.EXTENSIONS, Collections.emptySet());
        if (extensionsQuery.isEmpty()) {
            return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue(AddExtensions.OUTCOME_UPDATED, false);
        }
        List<AppArtifactCoords> extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery);
        ExtensionManager extensionManager = invocation.getValue(AddExtensions.EXTENSION_MANAGER, invocation.getQuarkusProject().getExtensionManager());
        try {
            if (extensionsToAdd != null) {
                ExtensionManager.InstallResult result = extensionManager.install(extensionsToAdd);
                result.getInstalled().forEach(a -> invocation.log().info(ConsoleMessageFormats.ok((String)("Extension " + a.getGroupId() + ":" + a.getArtifactId())) + " has been installed"));
                return (QuarkusCommandOutcome)new QuarkusCommandOutcome(true).setValue(AddExtensions.OUTCOME_UPDATED, result.isSourceUpdated());
            }
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to add extensions", e);
        }
        return (QuarkusCommandOutcome)new QuarkusCommandOutcome(false).setValue(AddExtensions.OUTCOME_UPDATED, false);
    }
}

