/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.keycloak.pep.runtime.HttpClientBuilder;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerTenantConfig;
import io.quarkus.keycloak.pep.runtime.PolicyEnforcerResolver;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

@Recorder
public class KeycloakPolicyEnforcerRecorder {
    final HttpConfiguration httpConfiguration;

    public KeycloakPolicyEnforcerRecorder(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public Supplier<PolicyEnforcerResolver> setup(OidcConfig oidcConfig, KeycloakPolicyEnforcerConfig config, TlsConfig tlsConfig) {
        final PolicyEnforcer defaultPolicyEnforcer = KeycloakPolicyEnforcerRecorder.createPolicyEnforcer(oidcConfig.defaultTenant, config.defaultTenant, tlsConfig);
        final HashMap<String, PolicyEnforcer> policyEnforcerTenants = new HashMap<String, PolicyEnforcer>();
        for (Map.Entry<String, KeycloakPolicyEnforcerTenantConfig> tenant : config.namedTenants.entrySet()) {
            OidcTenantConfig oidcTenantConfig = (OidcTenantConfig)oidcConfig.namedTenants.get(tenant.getKey());
            if (oidcTenantConfig == null) {
                throw new ConfigurationException("Failed to find a matching OidcTenantConfig for tenant: " + tenant.getKey());
            }
            policyEnforcerTenants.put(tenant.getKey(), KeycloakPolicyEnforcerRecorder.createPolicyEnforcer(oidcTenantConfig, tenant.getValue(), tlsConfig));
        }
        return new Supplier<PolicyEnforcerResolver>(){

            @Override
            public PolicyEnforcerResolver get() {
                return new PolicyEnforcerResolver(defaultPolicyEnforcer, policyEnforcerTenants, KeycloakPolicyEnforcerRecorder.this.httpConfiguration.readTimeout.toMillis());
            }
        };
    }

    private static PolicyEnforcer createPolicyEnforcer(OidcTenantConfig oidcConfig, KeycloakPolicyEnforcerTenantConfig keycloakPolicyEnforcerConfig, TlsConfig tlsConfig) {
        boolean trustAll;
        if (oidcConfig.applicationType.orElse(OidcTenantConfig.ApplicationType.SERVICE) == OidcTenantConfig.ApplicationType.WEB_APP && oidcConfig.roles.source.orElse(null) != OidcTenantConfig.Roles.Source.accesstoken) {
            throw new OIDCException("Application 'web-app' type is only supported if access token is the source of roles");
        }
        AdapterConfig adapterConfig = new AdapterConfig();
        String authServerUrl = (String)oidcConfig.getAuthServerUrl().get();
        try {
            adapterConfig.setRealm(authServerUrl.substring(authServerUrl.lastIndexOf(47) + 1));
            adapterConfig.setAuthServerUrl(authServerUrl.substring(0, authServerUrl.lastIndexOf("/realms")));
        }
        catch (Exception cause) {
            throw new ConfigurationException("Failed to parse the realm name.", (Throwable)cause);
        }
        adapterConfig.setResource((String)oidcConfig.getClientId().get());
        adapterConfig.setCredentials(KeycloakPolicyEnforcerRecorder.getCredentials(oidcConfig));
        boolean bl = oidcConfig.tls.getVerification().isPresent() ? oidcConfig.tls.getVerification().get() == OidcCommonConfig.Tls.Verification.NONE : (trustAll = tlsConfig.trustAll);
        if (trustAll) {
            adapterConfig.setDisableTrustManager(true);
            adapterConfig.setAllowAnyHostname(true);
        } else if (oidcConfig.tls.trustStoreFile.isPresent()) {
            adapterConfig.setTruststore(((Path)oidcConfig.tls.trustStoreFile.get()).toString());
            adapterConfig.setTruststorePassword(oidcConfig.tls.trustStorePassword.orElse("password"));
            if (OidcCommonConfig.Tls.Verification.CERTIFICATE_VALIDATION == oidcConfig.tls.verification.orElse(OidcCommonConfig.Tls.Verification.REQUIRED)) {
                adapterConfig.setAllowAnyHostname(true);
            }
        }
        adapterConfig.setConnectionPoolSize(keycloakPolicyEnforcerConfig.connectionPoolSize);
        if (oidcConfig.proxy.host.isPresent()) {
            Object host = (String)oidcConfig.proxy.host.get();
            if (!((String)host).startsWith("http://") && !((String)host).startsWith("https://")) {
                host = URI.create(authServerUrl).getScheme() + "://" + (String)host;
            }
            adapterConfig.setProxyUrl((String)host + ":" + oidcConfig.proxy.port);
        }
        PolicyEnforcerConfig enforcerConfig = KeycloakPolicyEnforcerRecorder.getPolicyEnforcerConfig(keycloakPolicyEnforcerConfig, adapterConfig);
        adapterConfig.setPolicyEnforcerConfig(enforcerConfig);
        return PolicyEnforcer.builder().authServerUrl(adapterConfig.getAuthServerUrl()).realm(adapterConfig.getRealm()).clientId(adapterConfig.getResource()).credentials(adapterConfig.getCredentials()).bearerOnly(adapterConfig.isBearerOnly()).enforcerConfig(enforcerConfig).httpClient(new HttpClientBuilder().build((AdapterHttpClientConfig)adapterConfig)).build();
    }

    private static Map<String, Object> getCredentials(OidcTenantConfig oidcConfig) {
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        Optional clientSecret = oidcConfig.getCredentials().getSecret();
        if (clientSecret.isPresent()) {
            credentials.put("secret", clientSecret.orElse(null));
        }
        return credentials;
    }

    private static Map<String, Map<String, Object>> getClaimInformationPointConfig(KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig config) {
        HashMap<String, Map<String, Object>> cipConfig = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, String>> entry : config.simpleConfig.entrySet()) {
            cipConfig.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
        }
        for (Map.Entry<String, Map<String, Object>> entry : config.complexConfig.entrySet()) {
            cipConfig.computeIfAbsent(entry.getKey(), s -> new HashMap()).putAll(new HashMap<String, Object>(entry.getValue()));
        }
        return cipConfig;
    }

    private static PolicyEnforcerConfig getPolicyEnforcerConfig(KeycloakPolicyEnforcerTenantConfig config, AdapterConfig adapterConfig) {
        PolicyEnforcerConfig enforcerConfig = new PolicyEnforcerConfig();
        enforcerConfig.setLazyLoadPaths(Boolean.valueOf(config.policyEnforcer.lazyLoadPaths));
        enforcerConfig.setEnforcementMode(config.policyEnforcer.enforcementMode);
        enforcerConfig.setHttpMethodAsScope(Boolean.valueOf(config.policyEnforcer.httpMethodAsScope));
        KeycloakPolicyEnforcerTenantConfig.KeycloakConfigPolicyEnforcer.PathCacheConfig pathCache = config.policyEnforcer.pathCache;
        PolicyEnforcerConfig.PathCacheConfig pathCacheConfig = new PolicyEnforcerConfig.PathCacheConfig();
        pathCacheConfig.setLifespan(pathCache.lifespan);
        pathCacheConfig.setMaxEntries(pathCache.maxEntries);
        enforcerConfig.setPathCacheConfig(pathCacheConfig);
        enforcerConfig.setClaimInformationPointConfig(KeycloakPolicyEnforcerRecorder.getClaimInformationPointConfig(config.policyEnforcer.claimInformationPoint));
        enforcerConfig.setPaths(config.policyEnforcer.paths.values().stream().map(pathConfig -> {
            PolicyEnforcerConfig.PathConfig config1 = new PolicyEnforcerConfig.PathConfig();
            config1.setName((String)pathConfig.name.orElse(null));
            config1.setPath((String)pathConfig.path.orElse(null));
            config1.setEnforcementMode(pathConfig.enforcementMode);
            config1.setMethods(pathConfig.methods.values().stream().map(methodConfig -> {
                PolicyEnforcerConfig.MethodConfig mConfig = new PolicyEnforcerConfig.MethodConfig();
                mConfig.setMethod(methodConfig.method);
                mConfig.setScopes(methodConfig.scopes);
                mConfig.setScopesEnforcementMode(methodConfig.scopesEnforcementMode);
                return mConfig;
            }).collect(Collectors.toList()));
            config1.setClaimInformationPointConfig(KeycloakPolicyEnforcerRecorder.getClaimInformationPointConfig(pathConfig.claimInformationPoint));
            return config1;
        }).collect(Collectors.toList()));
        return enforcerConfig;
    }
}

