/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment.devui;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.builder.BuildResult;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.runtime.devui.KubernetesManifestService;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class KubernetesDevUIProcessor {
    static volatile List<Manifest> manifests;
    static final Holder holder;

    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem create(CurateOutcomeBuildItem bi) {
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Kubernetes Manifests")).componentLink("qwc-kubernetes-manifest.js").icon("font-awesome-solid:rocket"));
        return pageBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCServiceForCache() {
        DevConsoleManager.register((String)"kubernetes-generate-manifest", ignored -> {
            try {
                List<Manifest> manifests = holder.getManifests();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (Manifest manifest : manifests) {
                    map.put(manifest.getName(), manifest.getContent());
                }
                return map;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return new JsonRPCProvidersBuildItem(KubernetesManifestService.class);
    }

    static {
        holder = new Holder();
    }

    public static final class Manifest {
        private final String name;
        private final String content;

        public Manifest(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static class GeneratedKubernetesResourceHandler
    implements BiConsumer<Map<String, byte[]>, BuildResult> {
        @Override
        public void accept(Map<String, byte[]> context, BuildResult buildResult) {
            SelectedKubernetesDeploymentTargetBuildItem selectedTargetBI = (SelectedKubernetesDeploymentTargetBuildItem)buildResult.consumeOptional(SelectedKubernetesDeploymentTargetBuildItem.class);
            if (selectedTargetBI == null) {
                return;
            }
            List generatedFilesBI = buildResult.consumeMulti(GeneratedKubernetesResourceBuildItem.class);
            for (GeneratedKubernetesResourceBuildItem bi : generatedFilesBI) {
                if (!bi.getName().startsWith(selectedTargetBI.getEntry().getName()) || !bi.getName().endsWith(".yml")) continue;
                context.put(bi.getName(), bi.getContent());
            }
        }
    }

    public static final class Holder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public List<Manifest> getManifests() throws BootstrapException {
            if (manifests != null) return manifests;
            Class<Holder> clazz = Holder.class;
            synchronized (Holder.class) {
                if (manifests != null) return manifests;
                manifests = new ArrayList<Manifest>();
                QuarkusBootstrap existing = (QuarkusBootstrap)DevConsoleManager.getQuarkusBootstrap();
                QuarkusBootstrap quarkusBootstrap = existing.clonedBuilder().setMode(QuarkusBootstrap.Mode.PROD).setIsolateDeployment(true).build();
                try (CuratedApplication bootstrap = quarkusBootstrap.bootstrap();){
                    AugmentAction augmentor = bootstrap.createAugmentor();
                    HashMap context = new HashMap();
                    augmentor.performCustomBuild(GeneratedKubernetesResourceHandler.class.getName(), context, new String[]{GeneratedKubernetesResourceBuildItem.class.getName(), SelectedKubernetesDeploymentTargetBuildItem.class.getName()});
                    for (Map.Entry entry : context.entrySet()) {
                        manifests.add(new Manifest((String)entry.getKey(), new String((byte[])entry.getValue())));
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return manifests;
            }
        }
    }
}

