/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class AddStatefulSetResourceDecorator
extends ResourceProvidingDecorator<KubernetesListFluent<?>> {
    private final String name;
    private final PlatformConfiguration config;

    public AddStatefulSetResourceDecorator(String name, PlatformConfiguration config) {
        this.name = name;
        this.config = config;
    }

    public void visit(KubernetesListFluent<?> list) {
        StatefulSetBuilder builder = (StatefulSetBuilder)list.getItems().stream().filter(this::containsStatefulSetResource).map(this.replaceExistingStatefulSetResource(list)).findAny().orElseGet(this::createStatefulSetResource).accept(StatefulSetBuilder.class, this::initStatefulSetResourceWithDefaults);
        list.addToItems(new HasMetadata[]{builder.build()});
    }

    private boolean containsStatefulSetResource(HasMetadata metadata) {
        return "StatefulSet".equalsIgnoreCase(metadata.getKind()) && this.name.equals(metadata.getMetadata().getName());
    }

    private void initStatefulSetResourceWithDefaults(StatefulSetBuilder builder) {
        StatefulSetFluent.SpecNested spec = builder.editOrNewSpec();
        ((StatefulSetSpecFluent.TemplateNested)((StatefulSetSpecFluent.TemplateNested)((StatefulSetFluent.SpecNested)spec.editOrNewSelector().endSelector()).editOrNewTemplate().editOrNewSpec().endSpec()).editOrNewMetadata().endMetadata()).endTemplate();
        if (spec.getReplicas() == null) {
            spec.withReplicas(Integer.valueOf(1));
        }
        if (Strings.isNullOrEmpty((String)spec.getServiceName())) {
            spec.withServiceName(this.name);
        }
        if (spec.buildSelector().getMatchLabels() == null) {
            ((StatefulSetSpecFluent.SelectorNested)spec.editSelector().withMatchLabels(new HashMap())).endSelector();
        }
        if (spec.buildTemplate().getSpec().getTerminationGracePeriodSeconds() == null) {
            ((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)spec.editTemplate().editSpec().withTerminationGracePeriodSeconds(Long.valueOf(10L))).endSpec()).endTemplate();
        }
        if (!this.containsContainerWithName((StatefulSetFluent.SpecNested<StatefulSetBuilder>)spec)) {
            ((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)spec.editTemplate().editSpec().addNewContainer().withName(this.name)).endContainer()).endSpec()).endTemplate();
        }
        spec.endSpec();
    }

    private StatefulSetBuilder createStatefulSetResource() {
        return (StatefulSetBuilder)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder().withNewMetadata().withName(this.name)).endMetadata();
    }

    private Function<HasMetadata, StatefulSetBuilder> replaceExistingStatefulSetResource(KubernetesListFluent<?> list) {
        return metadata -> {
            list.removeFromItems(new HasMetadata[]{metadata});
            return new StatefulSetBuilder((StatefulSet)metadata);
        };
    }

    private boolean containsContainerWithName(StatefulSetFluent.SpecNested<StatefulSetBuilder> spec) {
        List containers = spec.buildTemplate().getSpec().getContainers();
        return containers == null || containers.stream().anyMatch(c -> this.name.equals(c.getName()));
    }
}

