/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.knative.decorator.AddAwsElasticBlockStoreVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddAzureDiskVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddAzureFileVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddConfigMapVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddEmptyDirVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddHostAliasesToRevisionDecorator;
import io.dekorate.knative.decorator.AddPvcVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddSecretVolumeToRevisionDecorator;
import io.dekorate.knative.decorator.AddSidecarToRevisionDecorator;
import io.dekorate.knative.decorator.ApplyAnnotationsToServiceTemplate;
import io.dekorate.knative.decorator.ApplyGlobalAutoscalingClassDecorator;
import io.dekorate.knative.decorator.ApplyGlobalRequestsPerSecondTargetDecorator;
import io.dekorate.knative.decorator.ApplyGlobalTargetUtilizationDecorator;
import io.dekorate.knative.decorator.ApplyLocalContainerConcurrencyDecorator;
import io.dekorate.knative.decorator.ApplyRevisionNameDecorator;
import io.dekorate.knative.decorator.ApplyServiceAccountToRevisionSpecDecorator;
import io.dekorate.knative.decorator.ApplyTrafficDecorator;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddConfigMapDataDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapResourceProvidingDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddImagePullSecretToServiceAccountDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.project.Project;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.spi.KubernetesClientCapabilityBuildItem;
import io.quarkus.kubernetes.deployment.AddPortToKnativeConfig;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceAccountNameToRevisionSpecDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.AutoScalerClassConverter;
import io.quarkus.kubernetes.deployment.AutoScalingMetricConverter;
import io.quarkus.kubernetes.deployment.AwsElasticBlockStoreVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureDiskVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureFileVolumeConverter;
import io.quarkus.kubernetes.deployment.ChangeContainerNameDecorator;
import io.quarkus.kubernetes.deployment.ConfigMapVolumeConverter;
import io.quarkus.kubernetes.deployment.ContainerConverter;
import io.quarkus.kubernetes.deployment.EmptyDirVolumeConverter;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.HostAliasConverter;
import io.quarkus.kubernetes.deployment.KnativeConfig;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.PvcVolumeConverter;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.deployment.SecretVolumeConverter;
import io.quarkus.kubernetes.deployment.TrafficConfig;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthStartupPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesServiceAccountBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class KnativeProcessor {
    private static final int KNATIVE_PRIORITY = 0;
    private static final String LATEST_REVISION = "latest";
    private static final String KNATIVE_CONFIG_AUTOSCALER = "config-autoscaler";
    private static final String KNATIVE_CONFIG_DEFAULTS = "config-defaults";
    private static final String KNATIVE_SERVING = "knative-serving";
    private static final String KNATIVE_MIN_SCALE = "autoscaling.knative.dev/minScale";
    private static final String KNATIVE_MAX_SCALE = "autoscaling.knative.dev/maxScale";
    private static final String KNATIVE_AUTOSCALING_METRIC = "autoscaling.knative.dev/metric";
    private static final String KNATIVE_AUTOSCALING_CLASS = "autoscaling.knative.dev/class";
    private static final String KNATIVE_AUTOSCALING_CLASS_SUFFIX = ".autoscaling.knative.dev";
    private static final String KNATIVE_UTILIZATION_PERCENTAGE = "autoscaling.knative.dev/target-utilization-percentage";
    private static final String KNATIVE_AUTOSCALING_TARGET = "autoscaling.knative.dev/target";
    private static final String KNATIVE_CONTAINER_CONCURRENCY = "container-concurrency";
    private static final String KNATIVE_DEV_VISIBILITY = "networking.knative.dev/visibility";

    @BuildStep
    public void checkKnative(ApplicationInfoBuildItem applicationInfo, KnativeConfig config, BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets, BuildProducer<KubernetesResourceMetadataBuildItem> resourceMeta) {
        List<String> targets = KubernetesConfigUtil.getConfiguredDeploymentTargets();
        boolean knativeEnabled = targets.contains("knative");
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("knative", "Service", "serving.knative.dev", "v1", 0, knativeEnabled, config.deployStrategy));
        if (knativeEnabled) {
            String name = ResourceNameUtil.getResourceName(config, applicationInfo);
            resourceMeta.produce((BuildItem)new KubernetesResourceMetadataBuildItem("knative", "serving.knative.dev", "v1", "Service", name));
        }
    }

    @BuildStep
    public void createAnnotations(KnativeConfig config, BuildProducer<KubernetesAnnotationBuildItem> annotations) {
        config.getAnnotations().forEach((k, v) -> annotations.produce((BuildItem)new KubernetesAnnotationBuildItem(k, v, "knative")));
    }

    @BuildStep
    public void createLabels(KnativeConfig config, BuildProducer<KubernetesLabelBuildItem> labels, BuildProducer<ContainerImageLabelBuildItem> imageLabels) {
        config.getLabels().forEach((k, v) -> {
            labels.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "knative"));
            imageLabels.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
    }

    @BuildStep
    public List<ConfiguratorBuildItem> createConfigurators(KnativeConfig config, List<KubernetesPortBuildItem> ports) {
        ArrayList<ConfiguratorBuildItem> result = new ArrayList<ConfiguratorBuildItem>();
        KubernetesCommonHelper.combinePorts(ports, config).values().stream().filter(p -> p.getName().equals("http")).findFirst().ifPresent(value -> result.add(new ConfiguratorBuildItem((Object)new AddPortToKnativeConfig((Port)value))));
        return result;
    }

    @BuildStep
    public List<DecoratorBuildItem> createDecorators(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, KnativeConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, Optional<KubernetesClientCapabilityBuildItem> kubernetesClientConfiguration, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, Optional<KubernetesHealthStartupPathBuildItem> startupProbePath, List<KubernetesRoleBuildItem> roles, List<KubernetesClusterRoleBuildItem> clusterRoles, List<KubernetesServiceAccountBuildItem> serviceAccounts, List<KubernetesRoleBindingBuildItem> roleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot, List<KubernetesDeploymentTargetBuildItem> targets) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        if (!targets.stream().filter(KubernetesDeploymentTargetBuildItem::isEnabled).anyMatch(t -> "knative".equals(t.getName()))) {
            return result;
        }
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, outputTarget, packageConfig);
        Optional<Port> port = KubernetesCommonHelper.getPort(ports, config, "http");
        result.addAll(KubernetesCommonHelper.createDecorators(project, "knative", name, config, metricsConfiguration, kubernetesClientConfiguration, annotations, labels, image, command, port, livenessPath, readinessPath, startupProbePath, roles, clusterRoles, serviceAccounts, roleBindings));
        image.ifPresent(i -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyContainerImageDecorator(name, i.getImage()))));
        result.add(new DecoratorBuildItem("knative", (Object)new ApplyImagePullPolicyDecorator(name, config.getImagePullPolicy())));
        config.getContainerName().ifPresent(containerName -> result.add(new DecoratorBuildItem("knative", (Object)new ChangeContainerNameDecorator((String)containerName))));
        Stream.concat(config.convertToBuildItems().stream(), envs.stream().filter(e -> e.getTarget() == null || "knative".equals(e.getTarget()))).forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build()))));
        if (config.clusterLocal && labels.stream().filter(l -> "knative".equals(l.getTarget())).noneMatch(l -> l.getKey().equals(KNATIVE_DEV_VISIBILITY))) {
            result.add(new DecoratorBuildItem("knative", (Object)new AddLabelDecorator(name, KNATIVE_DEV_VISIBILITY, "cluster-local", new String[0])));
        }
        config.minScale.map(String::valueOf).ifPresent(min -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyAnnotationsToServiceTemplate(name, new String[]{KNATIVE_MIN_SCALE, min}))));
        config.maxScale.map(String::valueOf).ifPresent(max -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyAnnotationsToServiceTemplate(name, new String[]{KNATIVE_MAX_SCALE, max}))));
        config.revisionAutoScaling.autoScalerClass.map(AutoScalerClassConverter::convert).ifPresent(a -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyAnnotationsToServiceTemplate(name, new String[]{KNATIVE_AUTOSCALING_CLASS, a.name().toLowerCase() + KNATIVE_AUTOSCALING_CLASS_SUFFIX}))));
        config.revisionAutoScaling.metric.map(AutoScalingMetricConverter::convert).ifPresent(m -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyAnnotationsToServiceTemplate(name, new String[]{KNATIVE_AUTOSCALING_METRIC, m.name().toLowerCase()}))));
        config.revisionAutoScaling.containerConcurrency.ifPresent(c -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyLocalContainerConcurrencyDecorator(name, (long)c.intValue()))));
        config.revisionAutoScaling.targetUtilizationPercentage.map(String::valueOf).ifPresent(t -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyAnnotationsToServiceTemplate(name, new String[]{KNATIVE_UTILIZATION_PERCENTAGE, t}))));
        config.revisionAutoScaling.target.map(String::valueOf).ifPresent(t -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyAnnotationsToServiceTemplate(name, new String[]{KNATIVE_AUTOSCALING_TARGET, t}))));
        config.globalAutoScaling.autoScalerClass.map(AutoScalerClassConverter::convert).ifPresent(a -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator(KNATIVE_CONFIG_AUTOSCALER, KNATIVE_SERVING)));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyGlobalAutoscalingClassDecorator(a)));
        });
        config.globalAutoScaling.containerConcurrency.map(String::valueOf).ifPresent(c -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator(KNATIVE_CONFIG_DEFAULTS, KNATIVE_SERVING)));
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapDataDecorator(KNATIVE_CONFIG_DEFAULTS, new String[]{KNATIVE_CONTAINER_CONCURRENCY, c})));
        });
        config.globalAutoScaling.requestsPerSecond.ifPresent(r -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator(KNATIVE_CONFIG_AUTOSCALER, KNATIVE_SERVING)));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyGlobalRequestsPerSecondTargetDecorator(r.intValue())));
        });
        config.globalAutoScaling.targetUtilizationPercentage.ifPresent(t -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator(KNATIVE_CONFIG_AUTOSCALER, KNATIVE_SERVING)));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyGlobalTargetUtilizationDecorator(t.intValue())));
        });
        if (!config.scaleToZeroEnabled) {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator(KNATIVE_CONFIG_AUTOSCALER, KNATIVE_SERVING)));
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapDataDecorator(KNATIVE_CONFIG_AUTOSCALER, new String[]{"enable-scale-to-zero", String.valueOf(config.scaleToZeroEnabled)})));
        }
        result.add(new DecoratorBuildItem("knative", (Object)new ApplyServiceTypeDecorator(name, config.getServiceType().name())));
        result.add(new DecoratorBuildItem("knative", (Object)new ApplyHttpGetActionPortDecorator(name, (Integer)null)));
        config.revisionName.ifPresent(r -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyRevisionNameDecorator(name, r))));
        config.traffic.forEach((k, v) -> {
            TrafficConfig traffic = v;
            boolean latestRevision = traffic.latestRevision.get();
            String revisionName = !latestRevision && LATEST_REVISION.equals(k) ? null : k;
            String tag = traffic.tag.orElse(null);
            long percent = traffic.percent.orElse(100L);
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyTrafficDecorator(name, revisionName, latestRevision, percent, tag)));
        });
        result.addAll(KnativeProcessor.createVolumeDecorators(project, name, config));
        config.getHostAliases().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddHostAliasesToRevisionDecorator(name, HostAliasConverter.convert(e)))));
        config.getSidecars().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddSidecarToRevisionDecorator(name, ContainerConverter.convert(e)))));
        if (!roleBindings.isEmpty()) {
            result.add(new DecoratorBuildItem((Object)new ApplyServiceAccountNameToRevisionSpecDecorator()));
        }
        config.getImagePullSecrets().ifPresent(imagePullSecrets -> {
            String serviceAccountName = config.getServiceAccount().orElse(name);
            result.add(new DecoratorBuildItem("knative", (Object)new AddServiceAccountResourceDecorator(name)));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyServiceAccountToRevisionSpecDecorator(name, serviceAccountName)));
            result.add(new DecoratorBuildItem("knative", (Object)new AddImagePullSecretToServiceAccountDecorator(serviceAccountName, imagePullSecrets)));
        });
        return result;
    }

    private static List<DecoratorBuildItem> createVolumeDecorators(Optional<Project> project, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        config.getSecretVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddSecretVolumeToRevisionDecorator(SecretVolumeConverter.convert(e)))));
        config.getConfigMapVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapVolumeToRevisionDecorator(ConfigMapVolumeConverter.convert(e)))));
        config.getEmptyDirVolumes().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddEmptyDirVolumeToRevisionDecorator(EmptyDirVolumeConverter.convert(e)))));
        config.getPvcVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddPvcVolumeToRevisionDecorator(PvcVolumeConverter.convert(e)))));
        config.getAwsElasticBlockStoreVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddAwsElasticBlockStoreVolumeToRevisionDecorator(AwsElasticBlockStoreVolumeConverter.convert(e)))));
        config.getAzureFileVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddAzureFileVolumeToRevisionDecorator(AzureFileVolumeConverter.convert(e)))));
        config.getAzureDiskVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddAzureDiskVolumeToRevisionDecorator(AzureDiskVolumeConverter.convert(e)))));
        return result;
    }
}

