/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.Timing;
import io.quarkus.runtime.annotations.Template;
import io.quarkus.undertow.runtime.DelegatingResourceManager;
import io.quarkus.undertow.runtime.HttpConfig;
import io.quarkus.undertow.runtime.KnownPathResourceManager;
import io.quarkus.undertow.runtime.QuarkusInstanceFactory;
import io.undertow.Undertow;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.handlers.DefaultServlet;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jboss.logging.Logger;
import org.wildfly.common.net.Inet;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@Template
public class UndertowDeploymentTemplate {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.undertow");
    public static final HttpHandler ROOT_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            currentRoot.handleRequest(exchange);
        }
    };
    private static volatile Undertow undertow;
    private static final List<HandlerWrapper> hotDeploymentWrappers;
    private static volatile List<Path> hotDeploymentResourcePaths;
    private static volatile HttpHandler currentRoot;

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public RuntimeValue<DeploymentInfo> createDeployment(String name, Set<String> knownFile, Set<String> knownDirectories, LaunchMode launchMode, ShutdownContext context) {
        Object resourceManager;
        final DeploymentInfo d = new DeploymentInfo();
        d.setSessionIdGenerator((SessionIdGenerator)new QuarkusSessionIdGenerator());
        d.setClassLoader(this.getClass().getClassLoader());
        d.setDeploymentName(name);
        d.setContextPath("/");
        d.setEagerFilterInit(true);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = new ClassLoader(){};
        }
        d.setClassLoader(cl);
        if (hotDeploymentResourcePaths == null) {
            resourceManager = new KnownPathResourceManager(knownFile, knownDirectories, (ResourceManager)new ClassPathResourceManager(d.getClassLoader(), "META-INF/resources"));
        } else {
            ArrayList<Object> managers = new ArrayList<Object>();
            for (Path i : hotDeploymentResourcePaths) {
                managers.add(new PathResourceManager(i));
            }
            managers.add(new ClassPathResourceManager(d.getClassLoader(), "META-INF/resources"));
            resourceManager = new DelegatingResourceManager(managers.toArray(new ResourceManager[0]));
        }
        if (launchMode == LaunchMode.NORMAL) {
            resourceManager = new CachingResourceManager(1000, 0L, null, (ResourceManager)resourceManager, 2000);
        }
        d.setResourceManager((ResourceManager)resourceManager);
        if (launchMode == LaunchMode.DEVELOPMENT || launchMode == LaunchMode.TEST) {
            d.setServletStackTraces(ServletStackTraces.LOCAL_ONLY);
        } else {
            d.setServletStackTraces(ServletStackTraces.NONE);
        }
        d.addWelcomePages(new String[]{"index.html", "index.htm"});
        d.addServlet(new ServletInfo("default", DefaultServlet.class).setAsyncSupported(true));
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    d.getResourceManager().close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close Servlet ResourceManager", (Throwable)e);
                }
            }
        });
        return new RuntimeValue((Object)d);
    }

    public static SocketAddress getHttpAddress() {
        for (Undertow.ListenerInfo info : undertow.getListenerInfo()) {
            if (!info.getProtcol().equals("http") || info.getSslContext() != null) continue;
            return info.getAddress();
        }
        return null;
    }

    public RuntimeValue<ServletInfo> registerServlet(RuntimeValue<DeploymentInfo> deploymentInfo, String name, Class<?> servletClass, boolean asyncSupported, int loadOnStartup, BeanContainer beanContainer, Map<String, String> initParams, InstanceFactory<? extends Servlet> instanceFactory) throws Exception {
        QuarkusInstanceFactory factory = instanceFactory != null ? instanceFactory : new QuarkusInstanceFactory(beanContainer.instanceFactory(servletClass, new Annotation[0]));
        ServletInfo servletInfo = new ServletInfo(name, servletClass, factory);
        for (Map.Entry<String, String> e : initParams.entrySet()) {
            servletInfo.addInitParam(e.getKey(), e.getValue());
        }
        ((DeploymentInfo)deploymentInfo.getValue()).addServlet(servletInfo);
        servletInfo.setAsyncSupported(asyncSupported);
        if (loadOnStartup > 0) {
            servletInfo.setLoadOnStartup(Integer.valueOf(loadOnStartup));
        }
        return new RuntimeValue((Object)servletInfo);
    }

    public void addServletInitParam(RuntimeValue<ServletInfo> info, String name, String value) {
        ((ServletInfo)info.getValue()).addInitParam(name, value);
    }

    public void addServletMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping) throws Exception {
        ServletInfo sv = (ServletInfo)((DeploymentInfo)info.getValue()).getServlets().get(name);
        sv.addMapping(mapping);
    }

    public void setMultipartConfig(RuntimeValue<ServletInfo> sref, String location, long fileSize, long maxRequestSize, int fileSizeThreshold) {
        MultipartConfigElement mp = new MultipartConfigElement(location, fileSize, maxRequestSize, fileSizeThreshold);
        ((ServletInfo)sref.getValue()).setMultipartConfig(mp);
    }

    public void setSecurityInfo(RuntimeValue<ServletInfo> sref, ServletSecurityInfo securityInfo) {
        ((ServletInfo)sref.getValue()).setServletSecurityInfo(securityInfo);
    }

    public void addSecurityRoleRef(RuntimeValue<ServletInfo> sref, String roleName, String roleLink) {
        ((ServletInfo)sref.getValue()).addSecurityRoleRef(roleName, roleLink);
    }

    public RuntimeValue<FilterInfo> registerFilter(RuntimeValue<DeploymentInfo> info, String name, Class<?> filterClass, boolean asyncSupported, BeanContainer beanContainer, Map<String, String> initParams, InstanceFactory<? extends Filter> instanceFactory) throws Exception {
        QuarkusInstanceFactory factory = instanceFactory != null ? instanceFactory : new QuarkusInstanceFactory(beanContainer.instanceFactory(filterClass, new Annotation[0]));
        FilterInfo filterInfo = new FilterInfo(name, filterClass, factory);
        for (Map.Entry<String, String> e : initParams.entrySet()) {
            filterInfo.addInitParam(e.getKey(), e.getValue());
        }
        ((DeploymentInfo)info.getValue()).addFilter(filterInfo);
        filterInfo.setAsyncSupported(asyncSupported);
        return new RuntimeValue((Object)filterInfo);
    }

    public void addFilterInitParam(RuntimeValue<FilterInfo> info, String name, String value) {
        ((FilterInfo)info.getValue()).addInitParam(name, value);
    }

    public void addFilterURLMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping, DispatcherType dispatcherType) throws Exception {
        ((DeploymentInfo)info.getValue()).addFilterUrlMapping(name, mapping, dispatcherType);
    }

    public void addFilterServletNameMapping(RuntimeValue<DeploymentInfo> info, String name, String mapping, DispatcherType dispatcherType) throws Exception {
        ((DeploymentInfo)info.getValue()).addFilterServletNameMapping(name, mapping, dispatcherType);
    }

    public void registerListener(RuntimeValue<DeploymentInfo> info, Class<?> listenerClass, BeanContainer factory) {
        ((DeploymentInfo)info.getValue()).addListener(new ListenerInfo(listenerClass, new QuarkusInstanceFactory(factory.instanceFactory(listenerClass, new Annotation[0]))));
    }

    public void addServltInitParameter(RuntimeValue<DeploymentInfo> info, String name, String value) {
        ((DeploymentInfo)info.getValue()).addInitParameter(name, value);
    }

    public RuntimeValue<Undertow> startUndertow(ShutdownContext shutdown, ExecutorService executorService, final DeploymentManager manager, HttpConfig config, List<HandlerWrapper> wrappers, LaunchMode launchMode) throws Exception {
        if (undertow == null) {
            SSLContext context = config.ssl.toSSLContext();
            UndertowDeploymentTemplate.doServerStart(config, launchMode, context, executorService);
            if (launchMode != LaunchMode.DEVELOPMENT) {
                shutdown.addShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        XnioWorker worker = undertow.getWorker();
                        undertow.stop();
                        worker.shutdown();
                        undertow = null;
                    }
                });
            }
        }
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    manager.stop();
                }
                catch (ServletException e) {
                    log.error((Object)"Failed to stop deployment", (Throwable)e);
                }
                manager.undeploy();
            }
        });
        HttpHandler main = manager.getDeployment().getHandler();
        for (HandlerWrapper i : wrappers) {
            main = i.wrap(main);
        }
        currentRoot = main;
        Timing.setHttpServer((String)String.format("Listening on: " + undertow.getListenerInfo().stream().map(l -> {
            String address;
            if (l.getAddress() instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)l.getAddress();
                address = Inet.toURLString((InetAddress)inetAddress.getAddress(), (boolean)true) + ":" + inetAddress.getPort();
            } else {
                address = l.getAddress().toString();
            }
            return l.getProtcol() + "://" + address;
        }).collect(Collectors.joining(", ")), new Object[0]));
        return new RuntimeValue((Object)undertow);
    }

    public static void addHotDeploymentWrapper(HandlerWrapper handlerWrapper) {
        hotDeploymentWrappers.add(handlerWrapper);
    }

    private static void doServerStart(HttpConfig config, LaunchMode launchMode, SSLContext sslContext, ExecutorService executor) throws ServletException {
        if (undertow == null) {
            int port = config.determinePort(launchMode);
            int sslPort = config.determineSslPort(launchMode);
            log.debugf("Starting Undertow on port %d", port);
            CanonicalPathHandler rootHandler = new CanonicalPathHandler(ROOT_HANDLER);
            for (HandlerWrapper i : hotDeploymentWrappers) {
                rootHandler = i.wrap((HttpHandler)rootHandler);
            }
            XnioWorker.Builder workerBuilder = Xnio.getInstance().createWorkerBuilder().setExternalExecutorService(executor);
            Undertow.Builder builder = Undertow.builder().addHttpListener(port, config.host).setHandler((HttpHandler)rootHandler);
            if (config.ioThreads.isPresent()) {
                workerBuilder.setWorkerIoThreads(config.ioThreads.getAsInt());
            } else if (launchMode.isDevOrTest()) {
                workerBuilder.setWorkerIoThreads(2);
            } else {
                workerBuilder.setWorkerIoThreads(Runtime.getRuntime().availableProcessors() * 2);
            }
            XnioWorker worker = workerBuilder.build();
            builder.setWorker(worker);
            if (sslContext != null) {
                log.debugf("Starting Undertow HTTPS listener on port %d", sslPort);
                builder.addHttpsListener(sslPort, config.host, sslContext);
            }
            undertow = builder.build();
            undertow.start();
        }
    }

    public DeploymentManager bootServletContainer(RuntimeValue<DeploymentInfo> info, final BeanContainer beanContainer) {
        try {
            final ClassIntrospecter defaultVal = ((DeploymentInfo)info.getValue()).getClassIntrospecter();
            ((DeploymentInfo)info.getValue()).setClassIntrospecter(new ClassIntrospecter(){

                public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
                    final BeanContainer.Factory res = beanContainer.instanceFactory(clazz, new Annotation[0]);
                    if (res == null) {
                        return defaultVal.createInstanceFactory(clazz);
                    }
                    return new InstanceFactory<T>(){

                        public InstanceHandle<T> createInstance() throws InstantiationException {
                            final BeanContainer.Instance ih = res.create();
                            return new InstanceHandle<T>(){

                                public T getInstance() {
                                    return ih.get();
                                }

                                public void release() {
                                    ih.close();
                                }
                            };
                        }
                    };
                }
            });
            ServletContainer servletContainer = Servlets.defaultContainer();
            DeploymentManager manager = servletContainer.addDeployment((DeploymentInfo)info.getValue());
            manager.deploy();
            manager.start();
            return manager;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addServletContextAttribute(RuntimeValue<DeploymentInfo> deployment, String key, Object value1) {
        ((DeploymentInfo)deployment.getValue()).addServletContextAttribute(key, value1);
    }

    public void addServletExtension(RuntimeValue<DeploymentInfo> deployment, ServletExtension extension) {
        ((DeploymentInfo)deployment.getValue()).addServletExtension(extension);
    }

    public ServletExtension setupRequestScope(final BeanContainer beanContainer) {
        return new ServletExtension(){

            public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
                deploymentInfo.addThreadSetupAction(new ThreadSetupHandler(){

                    public <T, C> ThreadSetupHandler.Action<T, C> create(final ThreadSetupHandler.Action<T, C> action) {
                        return new ThreadSetupHandler.Action<T, C>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public T call(HttpServerExchange exchange, C context) throws Exception {
                                ManagedContext requestContext = beanContainer.requestContext();
                                if (requestContext.isActive()) {
                                    return action.call(exchange, context);
                                }
                                try {
                                    requestContext.activate();
                                    Object object = action.call(exchange, context);
                                    return object;
                                }
                                finally {
                                    requestContext.terminate();
                                }
                            }
                        };
                    }
                });
            }
        };
    }

    static {
        hotDeploymentWrappers = new CopyOnWriteArrayList<HandlerWrapper>();
        currentRoot = ResponseCodeHandler.HANDLE_404;
    }

    private static class QuarkusSessionIdGenerator
    implements SessionIdGenerator {
        private volatile SecureRandom random;
        private volatile int length = 30;
        private static final char[] SESSION_ID_ALPHABET;
        private static final String ALPHABET_PROPERTY = "io.undertow.server.session.SecureRandomSessionIdGenerator.ALPHABET";

        private QuarkusSessionIdGenerator() {
        }

        public String createSessionId() {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            byte[] bytes = new byte[this.length];
            this.random.nextBytes(bytes);
            return new String(this.encode(bytes));
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        private char[] encode(byte[] data) {
            char[] out = new char[(data.length + 2) / 3 * 4];
            char[] alphabet = SESSION_ID_ALPHABET;
            int i = 0;
            int index = 0;
            while (i < data.length) {
                boolean quad = false;
                boolean trip = false;
                int val = 0xFF & data[i];
                val <<= 8;
                if (i + 1 < data.length) {
                    val |= 0xFF & data[i + 1];
                    trip = true;
                }
                val <<= 8;
                if (i + 2 < data.length) {
                    val |= 0xFF & data[i + 2];
                    quad = true;
                }
                out[index + 3] = alphabet[quad ? val & 0x3F : 63];
                out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 63];
                out[index + 1] = alphabet[(val >>= 6) & 0x3F];
                out[index] = alphabet[(val >>= 6) & 0x3F];
                i += 3;
                index += 4;
            }
            return out;
        }

        static {
            String alphabet = System.getProperty(ALPHABET_PROPERTY, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
            if (alphabet.length() != 64) {
                throw new RuntimeException("io.undertow.server.session.SecureRandomSessionIdGenerator must be exactly 64 characters long");
            }
            SESSION_ID_ALPHABET = alphabet.toCharArray();
        }
    }
}

