/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.undertow.runtime.RewriteCorrectingHandlerWrappers;
import io.undertow.Handlers;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;

public class UndertowHandlersConfServletExtension
implements ServletExtension {
    public static final String META_INF_UNDERTOW_HANDLERS_CONF = "META-INF/undertow-handlers.conf";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        List handlerList;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream handlers = classLoader.getResourceAsStream(META_INF_UNDERTOW_HANDLERS_CONF);
        if (handlers != null && !(handlerList = PredicatedHandlersParser.parse((InputStream)handlers, (ClassLoader)classLoader)).isEmpty()) {
            deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)new RewriteCorrectingHandlerWrappers.PostWrapper());
            deploymentInfo.addOuterHandlerChainWrapper(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return Handlers.predicates((List)handlerList, (HttpHandler)handler);
                }
            });
            deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)new RewriteCorrectingHandlerWrappers.PreWrapper());
        }
    }
}

