/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.ResourceParamConverterProvider;
import org.jboss.resteasy.reactive.common.util.types.Types;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeParameterConverter;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class Deployment {
    private final ExceptionMapping exceptionMapping;
    private final ContextResolvers contextResolvers;
    private final ServerSerialisers serialisers;
    private final ServerRestHandler[] abortHandlerChain;
    private final EntityWriter dynamicEntityWriter;
    private final String prefix;
    private final ParamConverterProviders paramConverterProviders;
    private final ConfigurationImpl configuration;
    private final Supplier<Application> applicationSupplier;
    private final ThreadSetupAction threadSetupAction;
    private final RequestContextFactory requestContextFactory;
    private final List<ServerRestHandler> preMatchHandlers;
    private final List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> classMappers;
    private final List<RuntimeConfigurableServerRestHandler> runtimeConfigurableServerRestHandlers;

    public Deployment(ExceptionMapping exceptionMapping, ContextResolvers contextResolvers, ServerSerialisers serialisers, ServerRestHandler[] abortHandlerChain, EntityWriter dynamicEntityWriter, String prefix, ParamConverterProviders paramConverterProviders, ConfigurationImpl configuration, Supplier<Application> applicationSupplier, ThreadSetupAction threadSetupAction, RequestContextFactory requestContextFactory, List<ServerRestHandler> preMatchHandlers, List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> classMappers, List<RuntimeConfigurableServerRestHandler> runtimeConfigurableServerRestHandlers) {
        this.exceptionMapping = exceptionMapping;
        this.contextResolvers = contextResolvers;
        this.serialisers = serialisers;
        this.abortHandlerChain = abortHandlerChain;
        this.dynamicEntityWriter = dynamicEntityWriter;
        this.prefix = prefix;
        this.paramConverterProviders = paramConverterProviders;
        this.configuration = configuration;
        this.applicationSupplier = applicationSupplier;
        this.threadSetupAction = threadSetupAction;
        this.requestContextFactory = requestContextFactory;
        this.preMatchHandlers = preMatchHandlers;
        this.classMappers = classMappers;
        this.runtimeConfigurableServerRestHandlers = runtimeConfigurableServerRestHandlers;
    }

    public Supplier<Application> getApplicationSupplier() {
        return this.applicationSupplier;
    }

    public ConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public ExceptionMapping getExceptionMapping() {
        return this.exceptionMapping;
    }

    public ContextResolvers getContextResolvers() {
        return this.contextResolvers;
    }

    public ServerSerialisers getSerialisers() {
        return this.serialisers;
    }

    public ServerRestHandler[] getAbortHandlerChain() {
        return this.abortHandlerChain;
    }

    public EntityWriter getDynamicEntityWriter() {
        return this.dynamicEntityWriter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ParamConverterProviders getParamConverterProviders() {
        return this.paramConverterProviders;
    }

    public List<ServerRestHandler> getPreMatchHandlers() {
        return this.preMatchHandlers;
    }

    public List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> getClassMappers() {
        return this.classMappers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterConverter getRuntimeParamConverter(Class<?> fieldOwnerClass, String fieldName, boolean single) {
        Type genericType;
        Class klass;
        Field field;
        List<ResourceParamConverterProvider> providers = this.getParamConverterProviders().getParamConverterProviders();
        if (providers.size() <= 0) return null;
        try {
            field = fieldOwnerClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        if (single) {
            klass = field.getType();
            genericType = field.getGenericType();
        } else {
            genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Failed to find Collection supertype of " + field);
            Type[] args = Types.findInterfaceParameterizedTypes(field.getType(), (ParameterizedType)((ParameterizedType)genericType), Collection.class);
            if (args == null || args.length != 1) throw new RuntimeException("Failed to find Collection supertype of " + field);
            genericType = args[0];
            klass = Types.getRawType((Type)genericType);
        }
        Annotation[] annotations = field.getAnnotations();
        for (ResourceParamConverterProvider converterProvider : providers) {
            BeanFactory.BeanInstance instance = converterProvider.getFactory().createInstance();
            ParamConverter converter = ((ParamConverterProvider)instance.getInstance()).getConverter(klass, genericType, annotations);
            if (converter == null) continue;
            return new RuntimeParameterConverter(converter);
        }
        return null;
    }

    public ThreadSetupAction getThreadSetupAction() {
        return this.threadSetupAction;
    }

    public RequestContextFactory getRequestContextFactory() {
        return this.requestContextFactory;
    }

    public List<RuntimeConfigurableServerRestHandler> getRuntimeConfigurableServerRestHandlers() {
        return this.runtimeConfigurableServerRestHandlers;
    }
}

