/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import javax.ws.rs.core.MediaType;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.SseUtil;
import org.jboss.resteasy.reactive.server.core.StreamingUtil;
import org.jboss.resteasy.reactive.server.jaxrs.OutboundSseEventImpl;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherResponseHandler
implements ServerRestHandler {
    private static final Logger log = Logger.getLogger(PublisherResponseHandler.class);
    private static final ServerRestHandler[] AWOL = new ServerRestHandler[]{new ServerRestHandler(){

        @Override
        public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
            throw new IllegalStateException("FAILURE: should never be restarted");
        }
    }};

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        if (requestContext.getResult() instanceof Publisher) {
            Publisher result = (Publisher)requestContext.getResult();
            MediaType[] mediaTypes = requestContext.getTarget().getProduces().getSortedMediaTypes();
            if (mediaTypes.length != 1) {
                throw new IllegalStateException("Negotiation or dynamic media type not supported yet for Multi: please use a single @Produces annotation");
            }
            requestContext.setResponseContentType(mediaTypes[0]);
            requestContext.setGenericReturnType(requestContext.getTarget().getReturnType());
            requestContext.suspend();
            if (mediaTypes[0].isCompatible(MediaType.SERVER_SENT_EVENTS_TYPE)) {
                this.handleSse(requestContext, result);
            } else {
                boolean json = mediaTypes[0].isCompatible(MediaType.APPLICATION_JSON_TYPE);
                this.handleStreaming(requestContext, result, json);
            }
        }
    }

    private void handleStreaming(ResteasyReactiveRequestContext requestContext, Publisher<?> result, boolean json) {
        result.subscribe((Subscriber)new StreamingMultiSubscriber(requestContext, json));
    }

    private void handleSse(ResteasyReactiveRequestContext requestContext, Publisher<?> result) {
        result.subscribe((Subscriber)new SseMultiSubscriber(requestContext));
    }

    static abstract class AbstractMultiSubscriber
    implements Subscriber<Object> {
        protected Subscription subscription;
        protected ResteasyReactiveRequestContext requestContext;
        private boolean weClosed = false;

        AbstractMultiSubscriber(ResteasyReactiveRequestContext requestContext) {
            this.requestContext = requestContext;
            requestContext.restart(AWOL, true);
            requestContext.serverResponse().addCloseHandler(() -> {
                if (!this.weClosed && this.subscription != null) {
                    this.subscription.cancel();
                }
            });
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
            s.request(1L);
        }

        public void onComplete() {
            this.weClosed = true;
            this.requestContext.serverResponse().end();
            this.requestContext.serverRequest().closeConnection();
            this.requestContext.close();
        }

        public void onError(Throwable t) {
            this.handleException(this.requestContext, t);
        }

        protected void handleException(ResteasyReactiveRequestContext requestContext, Throwable t) {
            if (requestContext.serverResponse().headWritten()) {
                log.error((Object)"Exception in SSE server handling, impossible to send it to client", t);
            } else {
                requestContext.resume(t, true);
            }
        }
    }

    private static class StreamingMultiSubscriber
    extends AbstractMultiSubscriber {
        private boolean json;
        private String nextJsonPrefix;
        private boolean hadItem;

        StreamingMultiSubscriber(ResteasyReactiveRequestContext requestContext, boolean json) {
            super(requestContext);
            this.json = json;
            this.nextJsonPrefix = "[";
            this.hadItem = false;
        }

        public void onNext(Object item) {
            this.hadItem = true;
            StreamingUtil.send(this.requestContext, item, this.json ? this.nextJsonPrefix : null).handle(new BiFunction<Object, Throwable, Object>(){

                @Override
                public Object apply(Object v, Throwable t) {
                    if (t != null) {
                        try {
                            subscription.cancel();
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                        }
                        this.handleException(requestContext, t);
                    } else {
                        nextJsonPrefix = ",";
                        subscription.request(1L);
                    }
                    return null;
                }
            });
        }

        @Override
        public void onComplete() {
            if (!this.hadItem) {
                StreamingUtil.setHeaders(this.requestContext, this.requestContext.serverResponse());
            }
            if (this.json) {
                String postfix = !this.hadItem ? "[]" : "]";
                byte[] postfixBytes = postfix.getBytes(StandardCharsets.US_ASCII);
                this.requestContext.serverResponse().write(postfixBytes).handle((v, t) -> {
                    super.onComplete();
                    return null;
                });
            } else {
                super.onComplete();
            }
        }
    }

    private static class SseMultiSubscriber
    extends AbstractMultiSubscriber {
        SseMultiSubscriber(ResteasyReactiveRequestContext requestContext) {
            super(requestContext);
        }

        public void onNext(Object item) {
            OutboundSseEventImpl event = new OutboundSseEventImpl.BuilderImpl().data(item).build();
            SseUtil.send(this.requestContext, event).handle(new BiFunction<Object, Throwable, Object>(){

                @Override
                public Object apply(Object v, Throwable t) {
                    if (t != null) {
                        subscription.cancel();
                        this.handleException(requestContext, t);
                    } else {
                        subscription.request(1L);
                    }
                    return null;
                }
            });
        }
    }
}

