/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import ratpack.func.Action;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.capture.RatpackDslBacking;
import ratpack.groovy.internal.capture.RatpackDslClosures;
import ratpack.guice.Guice;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;

public class RatpackClosureConfigurer
implements Action<RatpackServerSpec> {
    private final Closure<?> closure;
    private final boolean ephemeralPort;

    public RatpackClosureConfigurer(Closure<?> closure, boolean ephemeralPort) {
        this.closure = closure;
        this.ephemeralPort = ephemeralPort;
    }

    public void execute(RatpackServerSpec server) throws Exception {
        RatpackDslClosures closures = new RatpackDslClosures(null);
        RatpackDslBacking backing = new RatpackDslBacking(closures);
        ClosureUtil.configureDelegateFirst(backing, this.closure);
        server.registry(Guice.registry(ClosureUtil.delegatingAction(closures.getBindings())));
        server.handlers(Groovy.chainAction(closures.getHandlers()));
        ServerConfigBuilder builder = ServerConfig.builder().development(true);
        if (this.ephemeralPort) {
            builder.port(0);
        }
        ClosureUtil.configureDelegateFirst(builder, closures.getServerConfig());
        server.serverConfig(builder);
    }
}

